/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import java.net.URI;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-modules")
@I18n(value="list.modules.command")
public class ListModulesCommand
implements AdminCommand {
    @Inject
    ModulesRegistry modulesRegistry;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription("List of modules");
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart top = report.getTopMessagePart();
        top.setMessage("List Of Modules");
        top.setChildrenType("Module");
        for (Module module : this.modulesRegistry.getModules()) {
            ActionReport.MessagePart childPart = top.addChild();
            String version = module.getModuleDefinition().getVersion();
            if (version == null) {
                version = "any";
            }
            childPart.setMessage(module.getModuleDefinition().getName() + ":" + version);
            childPart.addProperty("State", module.getState().toString());
            if (module.isSticky()) {
                childPart.addProperty("Sticky", "true");
            }
            if (!module.isShared()) {
                childPart.addProperty("visibility", "private");
            } else {
                childPart.addProperty("visibility", "public");
            }
            if (!module.getState().equals((Object)ModuleState.READY)) continue;
            childPart.setChildrenType("Module Characteristics");
            ActionReport.MessagePart provides = childPart.addChild();
            provides.setMessage("Provides to following services");
            provides.setChildrenType("Provides");
            ActionReport.MessagePart imports = childPart.addChild();
            imports.setMessage("List of imported modules");
            imports.setChildrenType("Imports");
            for (Module i : module.getImports()) {
                String importVersion = i.getModuleDefinition().getVersion();
                if (importVersion == null) {
                    importVersion = "any";
                }
                imports.addChild().setMessage(i.getModuleDefinition().getName() + ":" + importVersion);
            }
            ActionReport.MessagePart implementations = childPart.addChild();
            implementations.setMessage("List of Jars implementing the module");
            implementations.setChildrenType("Jar");
            for (URI location : module.getModuleDefinition().getLocations()) {
                implementations.addChild().setMessage(location.toString());
            }
        }
    }
}

