/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderRegistry {
    private static ProbeProviderRegistry _me = new ProbeProviderRegistry();
    private ConcurrentMap<String, FlashlightProbeProvider> providerMap = new ConcurrentHashMap<String, FlashlightProbeProvider>();

    private ProbeProviderRegistry() {
    }

    public static ProbeProviderRegistry getInstance() {
        return _me;
    }

    public static void cleanup() {
        _me = new ProbeProviderRegistry();
    }

    public Collection<FlashlightProbeProvider> getAllProbeProviders() {
        return Collections.unmodifiableCollection(this.providerMap.values());
    }

    public FlashlightProbeProvider getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName) {
        if (probeProviderName == null) {
            probeProviderName = "";
        }
        return (FlashlightProbeProvider)this.providerMap.get(this.makeName(moduleProviderName, moduleName, probeProviderName));
    }

    public FlashlightProbeProvider registerProbeProvider(FlashlightProbeProvider provider, Class clz) {
        String qname = this.makeName(provider, clz);
        if (this.providerMap.putIfAbsent(qname, provider) != null) {
            throw new IllegalStateException("Provider already mapped " + qname);
        }
        return provider;
    }

    private String makeName(FlashlightProbeProvider provider, Class clazz) {
        String ppName = provider.getProbeProviderName();
        if (ppName == null) {
            ppName = clazz.getName();
        }
        return this.makeName(provider.getModuleProviderName(), provider.getModuleName(), ppName);
    }

    private String makeName(String a, String b, String c) {
        StringBuilder sb = new StringBuilder();
        sb.append(a);
        sb.append(":");
        sb.append(b);
        sb.append(":");
        sb.append(c);
        return sb.toString();
    }
}

