/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.HashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="unset")
@Scoped(value=PerLookup.class)
public class UnsetCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(UnsetCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        UnsetCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "environment-variable";
        this.operandType = "STRING";
        this.operandMin = 1;
        this.operandMax = Integer.MAX_VALUE;
    }

    public int executeCommand() throws CommandException, CommandValidationException {
        int ret = 0;
        for (String name : this.operands) {
            if (!name.startsWith("AS_ADMIN_")) {
                logger.printMessage(strings.get("badEnvVarUnset", new Object[]{name}));
                ret = -1;
                continue;
            }
            if (this.env.get(name) == null) {
                logger.printMessage(strings.get("cantRemoveEnvVar", new Object[]{name}));
                ret = -1;
                continue;
            }
            this.env.remove(name);
        }
        return ret;
    }
}

