/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.HashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="change-admin-password")
@Scoped(value=PerLookup.class)
public class ChangeAdminPasswordCommand
extends RemoteCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeAdminPasswordCommand.class);

    protected void fetchCommandMetadata() {
        this.commandOpts = new HashSet();
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected void validate() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp()) {
            return;
        }
        try {
            String password = this.getPasswords();
            this.programOpts.setPassword(password);
        }
        catch (CommandValidationException cve) {
            throw new CommandException(cve);
        }
        super.validate();
        ChangeAdminPasswordCommand.addOption(this.commandOpts, "AS_ADMIN_PASSWORD", '\u0000', "PASSWORD", false, null);
        ChangeAdminPasswordCommand.addOption(this.commandOpts, "AS_ADMIN_NEWPASSWORD", '\u0000', "PASSWORD", false, null);
        this.operandType = "STRING";
        this.operandMax = 1;
        this.operandMin = 1;
        this.operands = new ArrayList();
        this.operands.add(this.programOpts.getUser());
        this.options.put("AS_ADMIN_PASSWORD", this.passwords.get("AS_ADMIN_PASSWORD"));
        this.options.put("AS_ADMIN_NEWPASSWORD", this.passwords.get("AS_ADMIN_NEWPASSWORD"));
    }

    private String getPasswords() throws CommandValidationException {
        String prompt = strings.get("AdminPasswordPrompt");
        String newprompt = strings.get("AdminNewPasswordPrompt");
        String confirmationPrompt = strings.get("AdminNewPasswordConfirmationPrompt");
        String oldpassword = this.readPassword(prompt);
        if (!this.isPasswordValid(oldpassword)) {
            throw new CommandValidationException(strings.get("PasswordLimit", new Object[]{"Admin"}));
        }
        this.passwords.put("AS_ADMIN_PASSWORD", oldpassword);
        String newpassword = this.readPassword(newprompt);
        if (!this.isPasswordValid(newpassword)) {
            throw new CommandValidationException(strings.get("PasswordLimit", new Object[]{"Admin"}));
        }
        this.passwords.put("AS_ADMIN_NEWPASSWORD", newpassword);
        String newpasswordAgain = this.readPassword(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        return oldpassword;
    }
}

