/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.StopDomainCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-domain")
@Scoped(value=PerLookup.class)
public class RestartDomainCommand
extends StopDomainCommand {
    private long uptimeOldServer;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartDomainCommand.class);

    protected void doCommand() throws CommandException, CommandValidationException {
        this.uptimeOldServer = this.getUptime();
        RemoteCommand cmd = new RemoteCommand("restart-domain", this.programOpts, this.env);
        cmd.executeAndReturnOutput("restart-domain");
        this.waitForRestart();
        logger.printMessage(strings.get("restartDomain.success"));
    }

    protected int dasNotRunning() {
        logger.printWarning(strings.get("restart.dasNotRunning"));
        return 1;
    }

    private long getUptime() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput("uptime");
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException(strings.get("restart.dasNotRunning"));
        }
        logger.printDebugMessage("server uptime: " + up_ms);
        return up_ms;
    }

    private long parseUptime(String up) {
        if (up == null || up.length() < 4) {
            return 0L;
        }
        int index = (up = up.trim()).lastIndexOf(58);
        if (index < 0) {
            return 0L;
        }
        if (up.length() - index < 3) {
            return 0L;
        }
        try {
            return Long.parseLong(up.substring(index + 2));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void waitForRestart() throws CommandException {
        long end = 600000L + System.currentTimeMillis();
        while (System.currentTimeMillis() < end) {
            try {
                long up;
                Thread.sleep(300L);
                if (this.domainName != null) {
                    this.initializeLocalPassword(this.domainRootDir);
                }
                if ((up = this.getUptime()) <= 0L || up >= this.uptimeOldServer) continue;
                return;
            }
            catch (Exception exception) {
            }
        }
        throw new CommandException(strings.get("restartDomain.noGFStart"));
    }
}

