/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.logging.LogDomains;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DownloadableArtifacts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientArtifactsManager {
    private boolean isArtifactSetConsumed = false;
    private static final String CLIENT_ARTIFACTS_KEY = "ClientArtifacts";
    private final Logger logger = LogDomains.getLogger(ClientArtifactsManager.class, (String)"javax.enterprise.system.tools.deployment");
    private final Set<DownloadableArtifacts.FullAndPartURIs> artifacts = new HashSet<DownloadableArtifacts.FullAndPartURIs>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientArtifactsManager get(DeploymentContext dc) {
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            ClientArtifactsManager result = (ClientArtifactsManager)dc.getTransientAppMetaData(CLIENT_ARTIFACTS_KEY, ClientArtifactsManager.class);
            if (result == null) {
                result = new ClientArtifactsManager();
                dc.addTransientAppMetaData(CLIENT_ARTIFACTS_KEY, (Object)result);
            }
            return result;
        }
    }

    public void add(URI baseURI, URI artifactURI) {
        URI relativeURI;
        URI absoluteURI;
        if (artifactURI.isAbsolute()) {
            absoluteURI = artifactURI;
            relativeURI = baseURI.relativize(absoluteURI);
        } else {
            relativeURI = artifactURI;
            absoluteURI = baseURI.resolve(relativeURI);
        }
        if (this.isArtifactSetConsumed) {
            String format = this.logger.getResourceBundle().getString("enterprise.deployment.backend.appClientArtifactOutOfOrder");
            throw new IllegalStateException(MessageFormat.format(format, absoluteURI.toASCIIString()));
        }
        this.artifacts.add(new DownloadableArtifacts.FullAndPartURIs(absoluteURI, relativeURI));
    }

    public void add(File baseFile, File artifactFile) {
        this.add(baseFile.toURI(), artifactFile.toURI());
    }

    public void addAll(File baseFile, Collection<File> artifactFiles) {
        for (File f : artifactFiles) {
            this.add(baseFile, f);
        }
    }

    public Set<DownloadableArtifacts.FullAndPartURIs> artifacts() {
        this.isArtifactSetConsumed = true;
        return Collections.unmodifiableSet(this.artifacts);
    }
}

