/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-logger-levels")
public class ListLoggerLevels
implements AdminCommand {
    @Inject
    LoggingConfigImpl loggingConfig;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Map props = this.loggingConfig.getLoggingProperties();
            Set keys = props.keySet();
            for (String name : keys) {
                if (!name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                String n = name.substring(0, name.lastIndexOf(".level"));
                part.setMessage(n + ": " + (String)props.get(name));
            }
        }
        catch (IOException ex) {
            report.setMessage("Unable to get the logger names");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

