/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.embedded.Port;
import org.glassfish.kernel.embedded.PortsImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Scoped(value=PerLookup.class)
public class PortImpl
implements Port {
    @Inject
    CommandRunner runner = null;
    @Inject(name="plain")
    ActionReport report = null;
    @Inject
    PortsImpl ports;
    @Inject
    NetworkConfig config;
    String listenerName;
    int number;

    public void bind(final int portNumber) {
        this.number = portNumber;
        this.listenerName = this.getListenerName();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    protocol.setName(PortImpl.this.listenerName);
                    param.getProtocol().add(protocol);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setDefaultVirtualServer("server");
                    protocol.setHttp(http);
                    return protocol;
                }
            }, (ConfigBeanProxy)this.config.getProtocols());
            NetworkListener listener = (NetworkListener)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

                public Object run(NetworkListeners param) throws TransactionFailure {
                    NetworkListener listener = (NetworkListener)param.createChild(NetworkListener.class);
                    listener.setName(PortImpl.this.listenerName);
                    listener.setAddress("127.0.0.1");
                    listener.setPort(Integer.toString(portNumber));
                    listener.setProtocol(PortImpl.this.listenerName);
                    listener.setThreadPool("http-thread-pool");
                    if (listener.findThreadPool() == null) {
                        ThreadPool pool = (ThreadPool)PortImpl.this.config.getNetworkListeners().createChild(ThreadPool.class);
                        pool.setName(PortImpl.this.listenerName);
                        listener.setThreadPool(PortImpl.this.listenerName);
                    }
                    listener.setTransport("tcp");
                    if (listener.findTransport() == null) {
                        Transport transport = (Transport)PortImpl.this.config.getTransports().createChild(Transport.class);
                        transport.setName(PortImpl.this.listenerName);
                        listener.setTransport(PortImpl.this.listenerName);
                    }
                    param.getNetworkListener().add(listener);
                    return listener;
                }
            }, (ConfigBeanProxy)this.config.getNetworkListeners());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getListenerName() {
        int i = 1;
        String name = "embedded-listener";
        while (this.existsListener(name)) {
            name = "embedded-listener-" + i++;
        }
        return name;
    }

    private boolean existsListener(String listenerName) {
        return false;
    }

    public void unbind() {
        List list = this.config.getNetworkListeners().getNetworkListener();
        for (NetworkListener listener : list) {
            if (!listener.getName().equals(this.listenerName)) continue;
            list.remove(listener);
            break;
        }
        this.ports.remove(this);
    }

    public int getPortNumber() {
        return this.number;
    }
}

