/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.net.NetUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="start-domain")
@Scoped(value=PerLookup.class)
public class StartDomainCommand
extends LocalDomainCommand {
    private GFLauncherInfo info;
    private GFLauncher launcher;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDomainCommand.class);

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        StartDomainCommand.addOption(opts, "debug", '\u0000', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "domaindir", '\u0000', "STRING", false, null);
        StartDomainCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "upgrade", '\u0000', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "verbose", 'v', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    @Override
    protected int executeCommand() throws CommandException {
        String gfejar = System.getenv("GFE_JAR");
        if (gfejar != null && gfejar.length() > 0) {
            return this.runCommandEmbedded();
        }
        return this.runCommandNotEmbedded();
    }

    private int runCommandNotEmbedded() throws CommandException {
        try {
            String parent;
            this.launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.domain);
            this.info = this.launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.get(0));
            }
            if ((parent = (String)this.options.get("domaindir")) != null) {
                this.info.setDomainParentDir(parent);
            }
            boolean verbose = this.getBooleanOption("verbose");
            boolean upgrade = this.getBooleanOption("upgrade");
            this.info.setVerbose(verbose || upgrade);
            this.info.setDebug(this.getBooleanOption("debug"));
            this.info.setUpgrade(upgrade);
            this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.programOpts.getProgramArguments());
            this.launcher.setup();
            Set adminPorts = this.info.getAdminPorts();
            for (Integer port : adminPorts) {
                if (NetUtils.isPortFree((int)port)) continue;
                String msg = strings.get("ServerRunning", new Object[]{port.toString()});
                logger.printWarning(msg);
                return 1;
            }
            this.setMasterPassword(this.info);
            this.launcher.launch();
            if (verbose || upgrade) {
                while (this.launcher.getExitValue() == 10) {
                    logger.printMessage(strings.get("restart"));
                    if (CLIConstants.debugMode) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
                return this.launcher.getExitValue();
            }
            this.waitForDAS(this.info.getAdminPorts());
            this.report(this.info);
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void setMasterPassword(GFLauncherInfo info) throws CommandException {
        boolean ok;
        String mpn = "AS_ADMIN_MASTERPASSWORD";
        String mpv = (String)this.passwords.get(mpn);
        if (mpv == null) {
            mpv = this.checkMasterPasswordFile();
        }
        if (mpv == null) {
            mpv = "changeit";
        }
        if (!(ok = this.verifyMasterPassword(mpv))) {
            mpv = this.retry(3);
        }
        info.addSecurityToken(mpn, mpv);
    }

    private String retry(int times) throws CommandException {
        logger.printMessage("No valid master password found");
        for (int i = 0; i < times; ++i) {
            String prompt = "Enter master password (" + (times - i) + " attempt(s) remain)> ";
            String mpv = super.readPassword(prompt);
            if (mpv == null) {
                throw new CommandException("No console, no prompting possible");
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            logger.printMessage("Sorry, incorrect master password, retry");
        }
        throw new CommandException("Number of attempts (" + times + ") exhausted, giving up");
    }

    private int runCommandEmbedded() throws CommandException {
        try {
            this.launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.embedded);
            this.info = this.launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.get(0));
            } else {
                this.info.setDomainName("domain1");
            }
            String parent = (String)this.options.get("domaindir");
            if (parent != null) {
                this.info.setDomainParentDir(parent);
            } else {
                this.info.setDomainParentDir(System.getenv("S1AS_HOME") + "/domains");
            }
            boolean verbose = this.getBooleanOption("verbose");
            this.info.setVerbose(verbose);
            this.info.setDebug(this.getBooleanOption("debug"));
            this.launcher.setup();
            Set ports = this.info.getAdminPorts();
            if (this.isServerAlive(ports)) {
                throw new CommandException("The Admin port is already taken: ");
            }
            this.launcher.launch();
            this.waitForDAS(ports);
            this.report(this.info);
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void waitForDAS(Set<Integer> ports) throws CommandException {
        if (ports == null || ports.size() <= 0) {
            String msg = strings.get("noPorts");
            throw new CommandException(strings.get("CommandUnSuccessfulWithArg", new Object[]{this.name, msg}));
        }
        long startWait = System.currentTimeMillis();
        logger.printDetailMessage(strings.get("WaitDAS"));
        boolean alive = false;
        block5: while (!this.timedOut(startWait)) {
            for (int port : ports) {
                if (!this.isServerAlive(port)) continue;
                alive = true;
                break block5;
            }
            try {
                Process p = this.launcher.getProcess();
                int exitCode = p.exitValue();
                ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
                String output = psd.getOutErrString();
                if (StartDomainCommand.ok(output)) {
                    throw new CommandException(strings.get("dasDiedOutput", new Object[]{this.info.getDomainName(), exitCode, output}));
                }
                throw new CommandException(strings.get("dasDied", new Object[]{this.info.getDomainName(), exitCode}));
            }
            catch (GFLauncherException ex) {
            }
            catch (IllegalThreadStateException ex) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        if (!alive) {
            String msg = strings.get("dasNoStart", new Object[]{this.info.getDomainName(), 600L});
            throw new CommandException(msg);
        }
    }

    private boolean isServerAlive(int port) {
        logger.printDebugMessage("Check if server is alive on port " + port);
        this.programOpts.setPort(port);
        this.programOpts.setInteractive(false);
        return DASUtils.pingDASQuietly(this.programOpts, this.env);
    }

    private boolean isServerAlive(Set<Integer> ports) {
        if (ports == null || ports.size() == 0) {
            return false;
        }
        return this.isServerAlive(ports.iterator().next());
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 600000L;
    }

    private void report(GFLauncherInfo info) {
        String msg = strings.get("DomainLocation", new Object[]{info.getDomainName(), info.getDomainRootDir().getAbsolutePath()});
        logger.printMessage(msg);
        Integer ap = -1;
        try {
            ap = (Integer)info.getAdminPorts().iterator().next();
        }
        catch (Exception e) {
            // empty catch block
        }
        msg = strings.get("DomainAdminPort", new Object[]{"" + ap});
        logger.printMessage(msg);
    }
}

