/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="run-script")
@Scoped(value=PerLookup.class)
public final class RunScriptLocalCommand
extends RemoteCommand {
    public static final String HTTP_PORT = "httpport";
    public static final String SCRIPT_ID = "scriptid";
    private boolean upload = true;
    private int httpPort = 8080;
    private String scriptName;

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        RunScriptLocalCommand.addOption(opts, HTTP_PORT, '\u0000', "STRING", false, "8080");
        this.commandOpts = Collections.synchronizedSet(opts);
        this.operandName = "script";
        this.operandType = "FILE";
        this.operandMin = 1;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        String shttpPort = this.getOption(HTTP_PORT);
        if (RunScriptLocalCommand.ok(shttpPort)) {
            this.httpPort = Integer.parseInt(shttpPort);
        }
        String scriptPath = (String)this.operands.get(0);
        int i = scriptPath.lastIndexOf(File.separator);
        this.scriptName = scriptPath.substring(i + 1, scriptPath.length());
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        Object in = null;
        boolean isContinue = true;
        logger.printDebugMessage("In the run-script command");
        try {
            String scriptID = this.scriptName + UUID.randomUUID();
            this.commandOpts.add(new ValidOption(SCRIPT_ID, "STRING", 2, scriptID));
            this.options.put(SCRIPT_ID, scriptID);
            super.executeCommand();
            String urlStr = "http://" + this.programOpts.getHost() + ":" + this.httpPort + "/comet/cometServlet";
            logger.printDebugMessage("URL = " + urlStr);
            URL url1 = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url1.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            String data = URLEncoder.encode("script", "UTF-8") + "=" + URLEncoder.encode(scriptID, "UTF-8");
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            wr.close();
            try {
                int c;
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((c = rd.read()) >= 0) {
                    System.out.print((char)c);
                }
            }
            catch (ConnectException ce) {
                ce.printStackTrace();
                logger.printMessage("\nConnection terminated by server");
                return 1;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                logger.printMessage("\nConnection terminated by server, ioe");
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printRemoteException(e);
            return 1;
        }
    }

    private void printRemoteException(Exception e) {
        logger.printMessage("Command " + this.name + " is not supported");
        logger.printDebugMessage(e.getMessage());
        logger.printExceptionStackTrace(e);
    }
}

