/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-domain")
@Scoped(value=PerLookup.class)
public class StopDomainCommand
extends LocalDomainCommand {
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        StopDomainCommand.addOption(opts, "domaindir", '\u0000', "STRING", false, null);
        StopDomainCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    protected void initDomain() throws CommandException {
        if (this.programOpts.getHost().equals("localhost")) {
            super.initDomain();
        } else if (this.operands.size() > 0) {
            throw new CommandException(strings.get("StopDomain.noDomainNameAllowed"));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        if (this.domainName != null) {
            if (this.localPassword == null) {
                return this.dasNotRunning();
            }
            int adminPort = this.getAdminPort(this.getDomainXml());
            this.programOpts.setPort(adminPort);
            logger.printDebugMessage("Stopping local domain on port " + adminPort);
            this.programOpts.setInteractive(false);
        }
        if (this.domainName != null) {
            if (!this.isThisDAS(this.domainRootDir)) {
                return this.dasNotRunning();
            }
            logger.printDebugMessage("It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly(this.programOpts, this.env)) {
                return this.dasNotRunning();
            }
            logger.printDebugMessage("DAS is running");
        }
        this.programOpts.setInteractive(false);
        this.doCommand();
        return 0;
    }

    protected int dasNotRunning() throws CommandException, CommandValidationException {
        logger.printWarning(strings.get("StopDomain.dasNotRunning"));
        return 0;
    }

    protected void doCommand() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand(this.getName(), this.programOpts, this.env);
        cmd.executeAndReturnOutput("stop-domain");
        this.waitForDeath();
    }

    protected void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.err.print(strings.get("StopDomain.WaitDASDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning(this.programOpts.getPort())) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse()) continue;
                System.err.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.programOpts.isTerse()) {
            System.err.println();
        }
        if (alive) {
            throw new CommandException(strings.get("StopDomain.DASNotDead", new Object[]{60L}));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }
}

