/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.statistics.AverageRangeStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;

public final class AverageRangeStatisticImpl
extends StatisticImpl
implements AverageRangeStatistic,
InvocationHandler {
    public static final long DEFAULT_MAX_BOUND = Long.MAX_VALUE;
    private AtomicLong currentVal = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong highWaterMark = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong lowWaterMark = new AtomicLong(Long.MAX_VALUE);
    private long numberOfSamples;
    private long runningTotal;
    private AverageRangeStatistic as = (AverageRangeStatistic)Proxy.newProxyInstance(AverageRangeStatistic.class.getClassLoader(), new Class[]{AverageRangeStatistic.class}, (InvocationHandler)this);

    public AverageRangeStatisticImpl(long curVal, long highMark, long lowMark, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.currentVal.set(curVal);
        this.highWaterMark.set(highMark);
        this.lowWaterMark.set(lowMark);
        this.numberOfSamples = 0L;
        this.runningTotal = 0L;
    }

    public synchronized AverageRangeStatistic getStatistic() {
        return this.as;
    }

    public String toString() {
        return super.toString() + NEWLINE + "Current: " + this.getCurrent() + NEWLINE + "LowWaterMark: " + this.getLowWaterMark() + NEWLINE + "HighWaterMark: " + this.getHighWaterMark() + NEWLINE + "Average:" + this.getAverage();
    }

    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("current", this.getCurrent());
        m.put("lowwatermark", this.getLowWaterMark());
        m.put("highwatermark", this.getHighWaterMark());
        m.put("average", this.getAverage());
        return m;
    }

    public void reset() {
        super.reset();
        this.currentVal.set(Long.MIN_VALUE);
        this.highWaterMark.set(Long.MIN_VALUE);
        this.lowWaterMark.set(Long.MAX_VALUE);
        this.resetAverageStats();
    }

    private void resetAverageStats() {
        this.numberOfSamples = 0L;
        this.runningTotal = 0L;
    }

    public void setCount(long current) {
        this.currentVal.set(current);
        super.setLastSampleTime(System.currentTimeMillis());
        this.lowWaterMark.set(current < this.lowWaterMark.get() ? current : this.lowWaterMark.get());
        this.highWaterMark.set(current > this.highWaterMark.get() ? current : this.highWaterMark.get());
        if (Long.MAX_VALUE - this.runningTotal < current) {
            this.resetAverageStats();
        }
        ++this.numberOfSamples;
        this.runningTotal += current;
    }

    public long getAverage() {
        if (this.numberOfSamples == 0L) {
            return -1L;
        }
        return this.runningTotal / this.numberOfSamples;
    }

    public long getCurrent() {
        return this.currentVal.get();
    }

    public void setCurrent(long curVal) {
        this.currentVal.set(curVal);
    }

    public long getHighWaterMark() {
        return this.highWaterMark.get();
    }

    public void setHighWaterMark(long highMark) {
        this.highWaterMark.set(highMark);
    }

    public long getLowWaterMark() {
        long result = this.lowWaterMark.get();
        if (result == Long.MAX_VALUE) {
            result = 0L;
        }
        return result;
    }

    public void setLowWaterMark(long lowMark) {
        this.lowWaterMark.set(lowMark);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            result = method.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

