/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.logex;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.gmbal.generic.OperationTracer;
import org.glassfish.gmbal.logex.Chain;
import org.glassfish.gmbal.logex.ExceptionWrapper;
import org.glassfish.gmbal.logex.Log;
import org.glassfish.gmbal.logex.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperGenerator {
    private static final ShortFormatter formatter = new ShortFormatter();

    private WrapperGenerator() {
    }

    private static int findAnnotatedParameter(Annotation[][] pannos, Class<? extends Annotation> cls) {
        for (int ctr1 = 0; ctr1 < pannos.length; ++ctr1) {
            Annotation[] annos = pannos[ctr1];
            for (int ctr2 = 0; ctr2 < annos.length; ++ctr2) {
                Annotation anno = annos[ctr2];
                if (!cls.isInstance(anno)) continue;
                return ctr1;
            }
        }
        return -1;
    }

    private static Object[] getWithSkip(Object[] args, int skip) {
        if (skip >= 0) {
            Object[] result = new Object[args.length - 1];
            int rindex = 0;
            for (int ctr = 0; ctr < args.length; ++ctr) {
                if (ctr == skip) continue;
                result[rindex++] = args[ctr];
            }
            return result;
        }
        return args;
    }

    private static String getMessage(Method method, int numParams, String idPrefix, int logId) {
        Message message = method.getAnnotation(Message.class);
        StringBuilder sb = new StringBuilder();
        sb.append(idPrefix);
        sb.append(logId);
        sb.append(": ");
        if (message == null) {
            sb.append(method.getName());
            sb.append(' ');
            for (int ctr = 0; ctr < numParams; ++ctr) {
                if (ctr > 0) {
                    sb.append(", ");
                }
                sb.append("arg");
                sb.append(ctr);
                sb.append("={" + ctr + "}");
            }
        } else {
            sb.append(message.value());
        }
        return sb.toString();
    }

    private static void inferCaller(LogRecord lrec) {
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String wcname = "$Proxy";
        String baseName = WrapperGenerator.class.getName();
        String nestedName = WrapperGenerator.class.getName() + "$1";
        for (ix = 0; ix < stack.length && ((cname = (frame = stack[ix]).getClassName()).contains(wcname) || cname.equals(baseName) || cname.equals(nestedName)); ++ix) {
        }
        if (ix < stack.length) {
            lrec.setSourceClassName(frame.getClassName());
            lrec.setSourceMethodName(frame.getMethodName());
        }
    }

    private static Exception makeException(Class<?> rtype, String msg) {
        try {
            Constructor<?> cons = rtype.getConstructor(String.class);
            return (Exception)cons.newInstance(msg);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String handleMessageOnly(Method method, Logger logger, Object[] messageParams) {
        String msg;
        String transMsg = msg = method.getAnnotation(Message.class).value();
        ResourceBundle catalog = logger.getResourceBundle();
        if (catalog != null) {
            try {
                transMsg = catalog.getString(msg);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        String result = transMsg.indexOf("{0") >= 0 ? MessageFormat.format(transMsg, messageParams) : transMsg;
        return result;
    }

    private static ReturnType classifyReturnType(Method method) {
        Class<?> rtype = method.getReturnType();
        if (Exception.class.isAssignableFrom(rtype)) {
            return ReturnType.EXCEPTION;
        }
        if (rtype.equals(String.class)) {
            return ReturnType.STRING;
        }
        if (rtype.equals(Void.TYPE)) {
            return ReturnType.NULL;
        }
        throw new RuntimeException("Method " + method + " has an illegal return type");
    }

    private static LogRecord makeLogRecord(Level level, String key, Object[] args, Logger logger) {
        LogRecord result = new LogRecord(level, key);
        if (args != null && args.length > 0) {
            result.setParameters(args);
        }
        result.setLoggerName(logger.getName());
        result.setResourceBundle(logger.getResourceBundle());
        if (level != Level.INFO) {
            WrapperGenerator.inferCaller(result);
        }
        return result;
    }

    private static Object handleFullLogging(Log log, Method method, Logger logger, String idPrefix, Object[] messageParams, Throwable cause) {
        Level level = log.level().getLevel();
        ReturnType rtype = WrapperGenerator.classifyReturnType(method);
        int len = messageParams == null ? 0 : messageParams.length;
        String msgString = WrapperGenerator.getMessage(method, len, idPrefix, log.id());
        LogRecord lrec = WrapperGenerator.makeLogRecord(level, msgString, messageParams, logger);
        String message = formatter.format(lrec);
        Exception exc = null;
        if (rtype == ReturnType.EXCEPTION) {
            exc = WrapperGenerator.makeException(method.getReturnType(), message);
            if (cause != null) {
                exc.initCause(cause);
            }
            if (level != Level.INFO) {
                lrec.setThrown(exc);
            }
        }
        if (logger.isLoggable(level)) {
            String context = OperationTracer.getAsString();
            String newMsg = msgString;
            if (context.length() > 0) {
                newMsg = newMsg + "\nCONTEXT:" + context;
                lrec.setMessage(newMsg);
            }
            logger.log(lrec);
        }
        switch (rtype) {
            case EXCEPTION: {
                return exc;
            }
            case STRING: {
                return message;
            }
        }
        return null;
    }

    public static <T> T makeWrapper(final Class<T> cls) {
        if (!cls.isInterface()) {
            throw new IllegalArgumentException("Class " + cls + "is not an interface");
        }
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        final String idPrefix = ew.idPrefix();
        String str = ew.loggerName();
        if (str.length() == 0) {
            str = cls.getPackage().getName();
        }
        final String name = str;
        InvocationHandler inh = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Annotation[][] pannos = method.getParameterAnnotations();
                int chainIndex = WrapperGenerator.findAnnotatedParameter(pannos, Chain.class);
                Throwable cause = null;
                Object[] messageParams = WrapperGenerator.getWithSkip(args, chainIndex);
                if (chainIndex >= 0) {
                    cause = (Throwable)args[chainIndex];
                }
                Logger logger = Logger.getLogger(name);
                Class<?> rtype = method.getReturnType();
                Log log = method.getAnnotation(Log.class);
                if (log == null) {
                    if (!rtype.equals(String.class)) {
                        throw new IllegalArgumentException("No @Log annotation present on " + cls.getName() + "." + method.getName());
                    }
                    return WrapperGenerator.handleMessageOnly(method, logger, messageParams);
                }
                return WrapperGenerator.handleFullLogging(log, method, logger, idPrefix, messageParams, cause);
            }
        };
        ClassLoader loader = cls.getClassLoader();
        Class[] classes = new Class[]{cls};
        return (T)Proxy.newProxyInstance(loader, classes, inh);
    }

    static class ShortFormatter
    extends Formatter {
        ShortFormatter() {
        }

        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReturnType {
        EXCEPTION,
        STRING,
        NULL;

    }
}

