/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.api.monitoring.ProbeInfo;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeHandle;

public class FlashlightProbe
implements ProbeHandle,
ProbeInfo {
    public static String SELF = "@SELF";
    private int id;
    private Class providerClazz;
    private String moduleProviderName;
    private String moduleName;
    private String probeName;
    private String probeProviderName;
    private String[] probeParamNames;
    private Class[] paramTypes;
    private List<ProbeClientInvoker> invokerList = new ArrayList<ProbeClientInvoker>(2);
    private String providerJavaMethodName;
    private AtomicBoolean listenerEnabled = new AtomicBoolean(false);
    private String probeDesc;
    private Object dtraceProviderImpl;
    private Method dtraceMethod;
    private boolean hasSelf;
    private boolean hidden;

    public FlashlightProbe(int id, Class providerClazz, String moduleProviderName, String moduleName, String probeProviderName, String probeName, String[] probeParamNames, Class[] paramTypes, boolean self, boolean hidden) {
        this.id = id;
        this.providerClazz = providerClazz;
        this.moduleProviderName = moduleProviderName;
        this.moduleName = moduleName;
        this.probeProviderName = probeProviderName;
        this.probeName = probeName;
        this.probeDesc = moduleProviderName + ":" + moduleName + ":" + probeProviderName + ":" + probeName;
        this.hasSelf = self;
        this.hidden = hidden;
        if (self) {
            if (this.isMethodStatic()) {
                throw new RuntimeException("Monitoring: Cannot define \"self\" on a static method - " + this.probeDesc);
            }
            this.probeParamNames = new String[probeParamNames.length + 1];
            this.paramTypes = new Class[paramTypes.length + 1];
            this.probeParamNames[0] = SELF;
            this.paramTypes[0] = providerClazz;
            for (int index = 0; index < probeParamNames.length; ++index) {
                this.probeParamNames[index + 1] = probeParamNames[index];
                this.paramTypes[index + 1] = paramTypes[index];
            }
        } else {
            this.probeParamNames = probeParamNames;
            this.paramTypes = paramTypes;
        }
    }

    private boolean isMethodStatic() {
        boolean isMethodStatic = false;
        try {
            int modifier = this.getProviderClazz().getDeclaredMethod(this.getProviderJavaMethodName(), this.getParamTypes()).getModifiers();
            return Modifier.isStatic(modifier);
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean addInvoker(ProbeClientInvoker invoker) {
        boolean isFirst = this.invokerList.size() == 0;
        this.invokerList.add(invoker);
        this.listenerEnabled.set(true);
        return isFirst;
    }

    public synchronized boolean removeInvoker(ProbeClientInvoker invoker) {
        this.invokerList.remove(invoker);
        this.listenerEnabled.set(this.invokerList.size() > 0);
        return this.listenerEnabled.get();
    }

    public void fireProbe(Object[] params) {
        if (this.listenerEnabled.get()) {
            for (ProbeClientInvoker invoker : this.invokerList) {
                invoker.invoke(params);
            }
        }
    }

    public boolean isEnabled() {
        return this.listenerEnabled.get();
    }

    public int getId() {
        return this.id;
    }

    public String getModuleProviderName() {
        return this.moduleProviderName;
    }

    public String getModuleName() {
        return this.moduleProviderName;
    }

    public String getProbeProviderName() {
        return this.probeProviderName;
    }

    public String getProbeName() {
        return this.probeName;
    }

    public String[] getProbeParamNames() {
        return this.probeParamNames;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String getProviderJavaMethodName() {
        return this.providerJavaMethodName;
    }

    public void setProviderJavaMethodName(String providerJavaMethodName) {
        this.providerJavaMethodName = providerJavaMethodName;
    }

    public String getProbeDesc() {
        return this.probeDesc;
    }

    public Class getProviderClazz() {
        return this.providerClazz;
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder(this.moduleProviderName + ":" + this.moduleName + ":" + this.probeProviderName + ":" + this.probeName);
        sbldr.append(" ").append(this.providerJavaMethodName).append("(");
        String delim = "";
        for (Class c : this.paramTypes) {
            sbldr.append(delim).append(c == null ? " " : c.getName());
            delim = ", ";
        }
        sbldr.append(")");
        return sbldr.toString();
    }

    public void setDTraceProviderImpl(Object impl) {
        this.dtraceProviderImpl = impl;
    }

    public Object getDTraceProviderImpl() {
        return this.dtraceProviderImpl;
    }

    public Method getDTraceMethod() {
        return this.dtraceMethod;
    }

    public void setDTraceMethod(Method m) {
        this.dtraceMethod = m;
    }

    public boolean hasSelf() {
        return this.hasSelf;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

