/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-audit-module")
@Scoped(value=PerLookup.class)
@I18n(value="delete.audit.module")
public class DeleteAuditModule
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAuditModule.class);
    @Param(name="auditmodulename", primary=true)
    String auditModuleName;
    @Inject
    SecurityService securityService;
    AuditModule auditModule = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            for (AuditModule am : this.securityService.getAuditModule()) {
                if (!am.getName().equals(this.auditModuleName)) continue;
                this.auditModule = am;
            }
            if (this.auditModule == null) {
                report.setMessage(localStrings.getLocalString("delete.audit.module.notfound", "Specified Audit Module {0} not found", new Object[]{this.auditModuleName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getAuditModule().remove(DeleteAuditModule.this.auditModule);
                    return null;
                }
            }, (ConfigBeanProxy)this.securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.audit.module.fail", "Deletion of Audit Module {0} failed", new Object[]{this.auditModuleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        report.setMessage(localStrings.getLocalString("delete.audit.module.success", "Deletion of Audit Module {0} completed successfully", new Object[]{this.auditModuleName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

