/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-system-property")
@Scoped(value=PerLookup.class)
@I18n(value="delete.system.property")
public class DeleteSystemProperty
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSystemProperty.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="property_name", primary=true)
    String propName;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Object spb = "domain".equals(this.target) ? this.domain : this.domain.getServerNamed(this.target);
        if (spb == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets are ''domain'' and a server named ''server'' (default).", new Object[]{this.target});
            report.setMessage(msg);
            return;
        }
        if (!spb.containsProperty(this.propName)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("no.such.property", "System Property named {0} does not exist at the given target {1}", new Object[]{this.propName, this.target});
            report.setMessage(msg);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SystemPropertyBag>(){

                public Object run(SystemPropertyBag param) throws PropertyVetoException, TransactionFailure {
                    param.getSystemProperty().remove(param.getSystemProperty(DeleteSystemProperty.this.propName));
                    return param;
                }
            }, (ConfigBeanProxy)spb);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            String msg = localStrings.getLocalString("delete.sysprops.ok", "System Property named {0} deleted from given target {1}. Make sure that you remove any references to this property from configuration", new Object[]{this.propName, this.target});
            report.setMessage(msg);
        }
        catch (TransactionFailure tf) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tf);
        }
    }
}

