/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.LegacyConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="set")
@Scoped(value=PerLookup.class)
@I18n(value="set")
public class SetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    ConfigSupport config;
    @Param(primary=true)
    String target;
    @Param(optional=true)
    String value;

    public void execute(AdminCommandContext context) {
        int lastDotIndex;
        Pattern p = Pattern.compile("([^=]*)=(.*)");
        if (this.value == null) {
            Matcher m = p.matcher(this.target);
            if (m.matches()) {
                this.target = m.group(1);
                this.value = m.group(2);
            } else {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                context.getActionReport().setMessage("Invalid target " + this.target);
                return;
            }
        }
        if ((lastDotIndex = SetCommand.trueLastIndexOf(this.target, '.')) == -1) {
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            context.getActionReport().setMessage("Invalid target " + this.target);
            return;
        }
        String attrName = this.target.substring(lastDotIndex + 1);
        String pattern = this.target.substring(0, lastDotIndex);
        boolean isProperty = false;
        if ("property".equals(pattern.substring(pattern.lastIndexOf(46) + 1))) {
            pattern = this.target.replaceAll("\\\\\\.", "\\.");
            isProperty = true;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, pattern);
        if (matchingNodes.isEmpty() && (pattern = this.target.substring(0, this.target.lastIndexOf(46))).endsWith("property")) {
            pattern = pattern.substring(0, pattern.lastIndexOf(46));
            parentNodes = this.getAliasedParent(this.domain, pattern);
            pattern = parentNodes[0].relativeName;
            matchingNodes = this.getMatchingNodes(dottedNames, pattern);
            if (matchingNodes.isEmpty()) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                context.getActionReport().setMessage("No configuration found for " + pattern);
                return;
            }
            Dom parentNode = null;
            for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
                if (!node.getValue().equals(pattern)) continue;
                parentNode = node.getKey();
            }
            if (parentNode == null) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                context.getActionReport().setMessage("No configuration found for " + this.target);
                return;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("value", this.value);
            attributes.put("name", attrName);
            try {
                ConfigSupport.createAndSet((ConfigBean)((ConfigBean)parentNode), Property.class, attributes);
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
                this.runLegacyChecks(context);
                return;
            }
            catch (TransactionFailure transactionFailure) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                context.getActionReport().setFailureCause(transactionFailure);
                context.getActionReport().setMessage("Could not change the attributes : " + transactionFailure.getMessage());
                return;
            }
        }
        HashMap changes = new HashMap();
        boolean delPropertySuccess = false;
        boolean delProperty = false;
        HashMap<String, String> attrChanges = new HashMap<String, String>();
        if (isProperty) {
            attrName = "value";
            if (this.value == null || this.value.length() == 0) {
                delProperty = true;
            }
            attrChanges.put(attrName, this.value);
        }
        for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
            Dom targetNode = node.getKey();
            for (String name : targetNode.model.getAttributeNames()) {
                String finalDottedName = node.getValue() + "." + name;
                if (!this.matches(finalDottedName, pattern) || !this.matchName(attrName, name)) continue;
                ActionReport.MessagePart part = context.getActionReport().getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(node.getValue() + "." + name + "=" + this.value);
                if (!isProperty) {
                    if (this.value != null && this.value.length() > 0) {
                        attrChanges.put(name, this.value);
                    } else {
                        attrChanges.put(name, null);
                    }
                }
                if (delProperty) {
                    String str = node.getValue();
                    if (str.lastIndexOf(46) != -1) {
                        str = str.substring(str.lastIndexOf(46) + 1);
                    }
                    try {
                        if (str == null) continue;
                        ConfigSupport.deleteChild((ConfigBean)((ConfigBean)targetNode.parent()), (ConfigBean)((ConfigBean)targetNode));
                        delPropertySuccess = true;
                    }
                    catch (IllegalArgumentException ie) {
                        context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                        context.getActionReport().setFailureCause(ie);
                        context.getActionReport().setMessage("Could not delete the property : " + ie.getMessage());
                    }
                    catch (TransactionFailure transactionFailure) {
                        context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                        context.getActionReport().setFailureCause(transactionFailure);
                        context.getActionReport().setMessage("Could not change the attributes : " + transactionFailure.getMessage());
                    }
                    continue;
                }
                changes.put((ConfigBean)node.getKey(), attrChanges);
            }
        }
        if (!changes.isEmpty()) {
            try {
                this.config.apply(changes);
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
                this.runLegacyChecks(context);
            }
            catch (TransactionFailure transactionFailure) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                context.getActionReport().setFailureCause(transactionFailure);
                context.getActionReport().setMessage("Could not change the attributes : " + transactionFailure.getMessage());
            }
        } else if (delPropertySuccess) {
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        } else {
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            context.getActionReport().setMessage("No configuration found for " + pattern);
        }
    }

    private void runLegacyChecks(AdminCommandContext context) {
        Collection list = this.habitat.getAllByContract(LegacyConfigurationUpgrade.class);
        for (LegacyConfigurationUpgrade upgrade : list) {
            upgrade.execute(context);
        }
    }

    private static int trueLastIndexOf(String target, char ch) {
        int i = target.lastIndexOf(ch);
        while (i > 0 && target.charAt(i - 1) == '\\') {
            i = target.lastIndexOf(ch, i - 1);
        }
        return i;
    }
}

