/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInfo
extends ModuleInfo {
    private final Collection<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private final ReadableArchive source;
    private final Map<Class<? extends Object>, Object> metaData = new HashMap<Class<? extends Object>, Object>();
    private final Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    private String libraries;

    public ApplicationInfo(Events events, ReadableArchive source, String name) {
        super(events, name, new LinkedHashSet<EngineRef>(), null);
        this.source = source;
    }

    public void add(EngineRef ref) {
        this.engines.add(ref);
    }

    public void addMetaData(Object o) {
        this.metaData.put(o.getClass(), o);
    }

    public <T> T getMetaData(Class<T> c) {
        return c.cast(this.metaData.get(c));
    }

    public void addTransientAppMetaData(String metaDataKey, Object metaDataValue) {
        if (metaDataValue != null) {
            this.transientAppMetaData.put(metaDataKey, metaDataValue);
        }
    }

    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaDataValue = this.transientAppMetaData.get(key);
        if (metaDataValue != null) {
            return metadataType.cast(metaDataValue);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public void setLibraries(String libraries) {
        this.libraries = libraries;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Collection<ModuleInfo> getModuleInfos() {
        return this.modules;
    }

    @Override
    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef ref : this.engines) {
            sniffers.add(ref.getContainerInfo().getSniffer());
        }
        for (ModuleInfo module : this.modules) {
            sniffers.addAll(module.getSniffers());
        }
        return sniffers;
    }

    public <T extends Container> Collection<EngineRef> getEngineRefsForContainer(Class<T> type) {
        LinkedHashSet<EngineRef> refs = new LinkedHashSet<EngineRef>();
        for (ModuleInfo info : this.modules) {
            EngineRef ref = null;
            try {
                ref = info.getEngineRefForContainer(type);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    protected ExtendedDeploymentContext getSubContext(ModuleInfo info, ExtendedDeploymentContext context) {
        return context;
    }

    @Override
    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        super.load(context, tracker);
        for (ModuleInfo module : this.modules) {
            module.load(this.getSubContext(module, context), tracker);
        }
        this.transientAppMetaData.putAll(context.getTransientAppMetadata());
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_LOADED, (Object)this), false);
        }
    }

    public void start(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        super.start(context, tracker);
        for (ModuleInfo module : this.getModuleInfos()) {
            module.start(this.getSubContext(module, context), tracker);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_STARTED, (Object)this), false);
        }
    }

    public void stop(ExtendedDeploymentContext context, Logger logger) {
        super.stop((ApplicationContext)context, logger);
        for (ModuleInfo module : this.getModuleInfos()) {
            module.stop((ApplicationContext)this.getSubContext(module, context), logger);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_STOPPED, (Object)this), false);
        }
    }

    @Override
    public void unload(ExtendedDeploymentContext context) {
        super.unload(context);
        for (ModuleInfo module : this.getModuleInfos()) {
            module.unload(this.getSubContext(module, context));
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_UNLOADED, (Object)this), false);
        }
    }

    @Override
    public boolean suspend(Logger logger) {
        boolean isSuccess = super.suspend(logger);
        for (ModuleInfo module : this.modules) {
            if (module.suspend(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean resume(Logger logger) {
        boolean isSuccess = super.resume(logger);
        for (ModuleInfo module : this.modules) {
            if (module.resume(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public void clean(ExtendedDeploymentContext context) throws Exception {
        super.clean(context);
        for (ModuleInfo info : this.modules) {
            info.clean(this.getSubContext(info, context));
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_CLEANED, (Object)context), false);
        }
    }

    public void save(Application app) throws TransactionFailure, PropertyVetoException {
        for (EngineRef ref : this.engines) {
            Engine engine = (Engine)app.createChild(Engine.class);
            app.getEngine().add(engine);
            ref.save(engine);
        }
        for (ModuleInfo module : this.modules) {
            Module modConfig = (Module)app.createChild(Module.class);
            app.getModule().add(modConfig);
            module.save(modConfig);
        }
    }

    public void addModule(ModuleInfo info) {
        this.modules.add(info);
    }
}

