/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.logging.LogDomains;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.autodeploy.AutoDeployDirectoryScanner;
import org.glassfish.deployment.common.DeploymentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDeployedFilesManager {
    private static final Logger sLogger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    static final String STATUS_DIR_NAME = ".autodeploystatus";
    private static final String DS_STORE = ".DS_Store";
    private static final String OSGI_AUTODEPLOY_DIR = "bundles";
    private List<String> FILE_NAMES_TO_IGNORE_FOR_AUTODEPLOY = new ArrayList<String>();
    protected String statDir = null;

    public AutoDeployedFilesManager() {
    }

    protected AutoDeployedFilesManager(String s) {
        this.statDir = s;
        this.FILE_NAMES_TO_IGNORE_FOR_AUTODEPLOY.add(DS_STORE);
        this.FILE_NAMES_TO_IGNORE_FOR_AUTODEPLOY.add(OSGI_AUTODEPLOY_DIR);
    }

    public static AutoDeployedFilesManager loadStatus(File statusDir) throws Exception {
        return AutoDeployedFilesManager.loadStatus(statusDir.getAbsolutePath());
    }

    public static AutoDeployedFilesManager loadStatus(String autoDeploymentDir) throws Exception {
        String statusDir = autoDeploymentDir + File.separator + STATUS_DIR_NAME;
        AutoDeployedFilesManager adfm = new AutoDeployedFilesManager(statusDir);
        return adfm;
    }

    public void writeStatus() throws Exception {
    }

    public void setDeployedFileInfo(File f) throws Exception {
        File statusFile = this.getStatusFile(f);
        statusFile.createNewFile();
        statusFile.setLastModified(f.lastModified());
    }

    public void deleteDeployedFileInfo(File f) throws Exception {
        File statusFile = this.getStatusFile(f);
        statusFile.delete();
    }

    private File getStatusFile(File f) {
        File outDir = new File(this.statDir);
        outDir = AutoDeployedFilesManager.obtainFileStatusDir(f, outDir, outDir.getParentFile());
        return new File(outDir, f.getName());
    }

    static File obtainFileStatusDir(File f, File statDir, File autoDeployDir) {
        File dir = f.getParentFile();
        while (!dir.getAbsolutePath().equals(autoDeployDir.getAbsolutePath())) {
            statDir = new File(statDir, dir.getName());
            dir = dir.getParentFile();
        }
        statDir.mkdirs();
        return statDir;
    }

    public File[] getFilesForDeployment(File[] latestFiles) {
        if (latestFiles == null) {
            return new File[0];
        }
        ArrayList<File> arrList = new ArrayList<File>();
        for (File deployDirFile : latestFiles) {
            if (this.FILE_NAMES_TO_IGNORE_FOR_AUTODEPLOY.contains(deployDirFile.getName())) {
                if (!sLogger.isLoggable(Level.FINE)) continue;
                sLogger.fine("Skipping " + deployDirFile.getAbsolutePath() + " because its name is in the list of files to ignore");
                continue;
            }
            File statusFile = this.getStatusFile(deployDirFile);
            if (!statusFile.exists() || deployDirFile.lastModified() != statusFile.lastModified()) {
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.fine("Including " + deployDirFile.getAbsolutePath() + " in candidate files for deployment");
                }
                arrList.add(deployDirFile);
                continue;
            }
            if (!sLogger.isLoggable(Level.FINE)) continue;
            sLogger.fine("Skipping " + deployDirFile.getAbsolutePath() + " its status file exists and the timestamps on the status file and the autodeployed file match");
        }
        return arrList.toArray(new File[0]);
    }

    public File[] getFilesForUndeployment(File[] latestFiles) {
        File statusDir = new File(this.statDir);
        Set<File> statusFiles = AutoDeployDirectoryScanner.getListOfFilesAsSet(statusDir, true);
        if (statusFiles == null || statusFiles.isEmpty()) {
            return null;
        }
        for (File deployDirFile : latestFiles) {
            statusFiles.remove(this.getStatusFile(deployDirFile));
        }
        ArrayList<? extends File> appNames = new ArrayList<File>();
        File autodeployDir = statusDir.getParentFile();
        for (File statusDirFile : statusFiles) {
            File filePath = autodeployDir;
            File f = statusDirFile.getParentFile();
            while (!f.equals(statusDir)) {
                filePath = new File(filePath, f.getName());
                f = f.getParentFile();
            }
            File _deployedMarkerFile = new File((filePath = new File(filePath, statusDirFile.getName())) + "_deployed");
            if (!_deployedMarkerFile.exists()) continue;
            appNames.add(filePath);
        }
        appNames.addAll(this.getFilesToUndeployByRequest(autodeployDir, statusDir));
        return appNames.toArray(new File[0]);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<? extends File> getFilesToUndeployByRequest(File autodeployDir, File statusDir) {
        void var6_8;
        ArrayList<UndeployRequestedFile> appsRequested = new ArrayList<UndeployRequestedFile>();
        File[] arr$ = statusDir.listFiles();
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            File f = arr$[var6_8];
            if (AutoDeployedFilesManager.isUndeployRequested(autodeployDir, f)) {
                appsRequested.add(new UndeployRequestedFile(new File(autodeployDir, f.getName())));
            }
            ++var6_8;
        }
        if (sLogger.isLoggable(Level.FINE) && !appsRequested.isEmpty()) {
            StringBuilder sb = new StringBuilder("Undeployment requested using *_undeployRequested for ");
            for (File file : appsRequested) {
                sb.append("  " + file.getName() + System.getProperty("line.separator"));
            }
            sLogger.fine(sb.toString());
        }
        return appsRequested;
    }

    private static boolean isUndeployRequested(File autodeployDir, File f) {
        return AutoDeployedFilesManager.appToUndeployRequestFile(autodeployDir, f).exists();
    }

    protected static File appToUndeployRequestFile(File autodeployDir, File f) {
        File undeployRequest = new File(autodeployDir, f.getName() + "_undeployRequested");
        return undeployRequest;
    }

    protected static File appToUndeployRequestFile(File f) {
        return AutoDeployedFilesManager.appToUndeployRequestFile(f.getParentFile(), f);
    }

    protected final class UndeployRequestedFile
    extends File {
        public UndeployRequestedFile(File parent, String child) {
            super(parent, child);
        }

        public UndeployRequestedFile(String path) {
            super(path);
        }

        public UndeployRequestedFile(String parent, String child) {
            super(parent, child);
        }

        public UndeployRequestedFile(URI uri) {
            super(uri);
        }

        public UndeployRequestedFile(File f) {
            super(f.getAbsolutePath());
        }
    }
}

