/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.DTraceContract;
import org.glassfish.external.probe.provider.annotations.Probe;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashlightUtils {
    private static final Logger logger = LogDomains.getLogger(FlashlightUtils.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlashlightUtils.class);
    private static Habitat habitat;
    private static MonitoringService monConfig;
    private static DTraceContract dt;
    private static boolean dtraceEnabled;
    private static boolean monitoringEnabled;
    private static final Object LOCK;
    private static final Class[] INTEGRAL_CLASSES;

    private FlashlightUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Habitat h, MonitoringService mc) {
        Object object = LOCK;
        synchronized (object) {
            if (habitat == null) {
                habitat = h;
                monConfig = mc;
                FlashlightUtils.setDTraceAvailabilty();
                FlashlightUtils.setDTraceEnabled(Boolean.parseBoolean(monConfig.getDtraceEnabled()));
                FlashlightUtils.setMonitoringEnabled(Boolean.parseBoolean(monConfig.getMonitoringEnabled()));
            }
        }
    }

    public static void setDTraceEnabled(boolean b) {
        FlashlightUtils.ok();
        dtraceEnabled = b;
    }

    public static void setMonitoringEnabled(boolean b) {
        FlashlightUtils.ok();
        monitoringEnabled = b;
    }

    public static boolean isMonitoringEnabled() {
        FlashlightUtils.ok();
        return monitoringEnabled;
    }

    public static boolean isDtraceAvailable() {
        FlashlightUtils.ok();
        if (dt == null) {
            return false;
        }
        if (!dtraceEnabled) {
            return false;
        }
        return monitoringEnabled;
    }

    public static boolean isDtraceEnabled() {
        return dtraceEnabled;
    }

    public static DTraceContract getDtraceEngine() {
        return FlashlightUtils.isDtraceAvailable() ? dt : null;
    }

    private static void setDTraceAvailabilty() {
        FlashlightUtils.ok();
        dt = (DTraceContract)habitat.getByContract(DTraceContract.class);
        if (dt == null) {
            return;
        }
        if (!dt.isSupported()) {
            dt = null;
        }
    }

    public static String[] getParamNames(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] paramNames = new String[paramTypes.length];
        Annotation[][] allAnns = method.getParameterAnnotations();
        int index = 0;
        for (Annotation[] paramAnns : allAnns) {
            paramNames[index] = FlashlightUtils.getParamName(paramAnns, paramTypes, index);
            ++index;
        }
        return paramNames;
    }

    public static List<Method> getProbeMethods(Class<?> clazz) {
        LinkedList<Method> list = new LinkedList<Method>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getAnnotation(Probe.class) == null) continue;
            list.add(m);
        }
        return list;
    }

    public static boolean isLegalDtraceParam(Class clazz) {
        return FlashlightUtils.isIntegral(clazz) || String.class.equals((Object)clazz);
    }

    public static boolean isIntegral(Class clazz) {
        for (Class c : INTEGRAL_CLASSES) {
            if (!c.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareIntegral(Class c1, Class c2) {
        if (!FlashlightUtils.isIntegral(c1) || !FlashlightUtils.isIntegral(c2)) {
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        if (c1.equals(Short.TYPE)) {
            return c2.equals(Short.class);
        }
        if (c1.equals(Long.TYPE)) {
            return c2.equals(Long.class);
        }
        if (c1.equals(Integer.TYPE)) {
            return c2.equals(Integer.class);
        }
        if (c1.equals(Byte.TYPE)) {
            return c2.equals(Byte.class);
        }
        if (c1.equals(Character.TYPE)) {
            return c2.equals(Character.class);
        }
        if (c1.equals(Boolean.TYPE)) {
            return c2.equals(Boolean.class);
        }
        if (c2.equals(Short.TYPE)) {
            return c1.equals(Short.class);
        }
        if (c2.equals(Long.TYPE)) {
            return c1.equals(Long.class);
        }
        if (c2.equals(Integer.TYPE)) {
            return c1.equals(Integer.class);
        }
        if (c2.equals(Byte.TYPE)) {
            return c1.equals(Byte.class);
        }
        if (c2.equals(Character.TYPE)) {
            return c1.equals(Character.class);
        }
        if (c2.equals(Boolean.TYPE)) {
            return c1.equals(Boolean.class);
        }
        return false;
    }

    public static String makeName(FlashlightProbeProvider provider) {
        return FlashlightUtils.makeName(provider.getModuleProviderName(), provider.getModuleName(), provider.getProbeProviderName());
    }

    public static String makeName(String a, String b, String c) {
        StringBuilder sb = new StringBuilder();
        sb.append(a);
        sb.append(":");
        sb.append(b);
        sb.append(":");
        sb.append(c);
        return sb.toString();
    }

    private static String getParamName(Annotation[] annotations, Class<?>[] paramTypes, int index) {
        String name = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ProbeParam)) continue;
            ProbeParam pp = (ProbeParam)annotation;
            name = pp.value();
        }
        if (name == null) {
            name = paramTypes[index].getName().replace('.', '_') + "_arg" + index;
        }
        return name;
    }

    private static void ok() {
        if (habitat == null || monConfig == null) {
            String errStr = localStrings.getLocalString("habitatNotSet", "Internal Error: habitat was not set in {0}", new Object[]{FlashlightUtils.class});
            throw new RuntimeException(errStr);
        }
    }

    static {
        LOCK = new Object();
        INTEGRAL_CLASSES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Integer.class, Long.class, Short.class, Boolean.class, Character.class, Byte.class};
    }
}

