/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.provider.FlashlightProbe;

public class DTraceClientInvoker
implements ProbeClientInvoker {
    private static final Logger logger = LogDomains.getLogger(DTraceClientInvoker.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DTraceClientInvoker.class);
    private final int id;
    private final Method method;
    private final Object targetObj;

    public DTraceClientInvoker(int ID, FlashlightProbe p) {
        this.id = ID;
        this.method = p.getDTraceMethod();
        this.targetObj = p.getDTraceProviderImpl();
    }

    public void invoke(Object[] args) {
        if (FlashlightUtils.isDtraceAvailable()) {
            try {
                this.method.invoke(this.targetObj, this.fixArgs(args));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, null, e.getMessage());
            }
        }
    }

    public int getId() {
        return this.id;
    }

    private Object[] fixArgs(Object[] args) {
        Object[] fixedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> clazz;
            fixedArgs[i] = args[i] == null ? null : (!FlashlightUtils.isLegalDtraceParam(clazz = args[i].getClass()) ? args[i].toString() : args[i]);
        }
        return fixedArgs;
    }
}

