/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.server.HK2Dispatcher;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.enterprise.v3.services.impl.SnifferAdapter;
import com.sun.grizzly.config.ContextRootInfo;
import com.sun.grizzly.config.FileCacheAware;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.MimeType;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.Collection;
import java.util.logging.Level;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.internal.grizzly.V3Mapper;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerMapper
extends StaticResourcesAdapter
implements FileCacheAware {
    private static final String ROOT = "";
    private Mapper mapper;
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private String defaultHostName = "server";
    private final UDecoder urlDecoder = new UDecoder();
    private final Habitat habitat;
    private final GrizzlyService grizzlyService;
    protected static final int MAPPING_DATA = 12;
    protected static final int MAPPED_ADAPTER = 13;
    private static final String serverName = System.getProperty("product.name") == null ? "" : System.getProperty("product.name");
    private static final byte[] errorBody = HttpUtils.getErrorPage(serverName, "HTTP Status 404");
    private final HK2Dispatcher hk2Dispatcher = new HK2Dispatcher();
    private boolean mapMultipleAdapter = false;

    public ContainerMapper(GrizzlyService grizzlyService, GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this.grizzlyEmbeddedHttp = grizzlyEmbeddedHttp;
        this.grizzlyService = grizzlyService;
        this.habitat = grizzlyService.habitat;
        this.logger = GrizzlyEmbeddedHttp.logger();
    }

    protected void setDefaultHost(String defaultHost) {
        this.defaultHostName = defaultHost;
    }

    protected void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected synchronized void configureMapper() {
        this.mapper.setDefaultHostName(this.defaultHostName);
        this.mapper.addHost(this.defaultHostName, new String[0], null);
        this.mapper.addContext(this.defaultHostName, ROOT, (Object)new ContextRootInfo((Adapter)this, null), new String[]{"index.html", "index.htm"}, null);
        Mapper.setAllowReplacement((boolean)true);
    }

    public void service(Request req, Response res) throws Exception {
        block22: {
            MappingData mappingData = null;
            try {
                if (!this.mapMultipleAdapter && this.mapper instanceof V3Mapper) {
                    req.setNote(12, null);
                    Adapter a = ((V3Mapper)this.mapper).getAdapter();
                    if (a != null) {
                        req.setNote(13, (Object)a);
                        a.service(req, res);
                        return;
                    }
                }
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                mappingData = (MappingData)req.getNote(12);
                if (mappingData == null) {
                    mappingData = new MappingData();
                    req.setNote(12, (Object)mappingData);
                }
                Adapter adapter = null;
                ByteChunk uriBB = decodedURI.getByteChunk();
                CharChunk uriCC = decodedURI.getCharChunk();
                int start = uriBB.getStart();
                int end = uriBB.getEnd();
                int semicolon = uriBB.indexOf(';', 0);
                byte[] trailer = null;
                if (semicolon > 0) {
                    trailer = new byte[end - semicolon];
                    System.arraycopy(uriBB.getBuffer(), semicolon, trailer, 0, trailer.length);
                    decodedURI.setBytes(uriBB.getBuffer(), uriBB.getStart(), semicolon);
                }
                String uriEncoding = (String)this.grizzlyEmbeddedHttp.getProperty("uriEncoding");
                HttpRequestURIDecoder.decode((MessageBytes)decodedURI, (UDecoder)this.urlDecoder, (String)uriEncoding, null);
                adapter = this.map(req, decodedURI, mappingData);
                if (adapter == null || adapter instanceof ContainerMapper) {
                    String ext = decodedURI.toString();
                    String type = ROOT;
                    if (ext.indexOf(".") > 0) {
                        ext = "*" + ext.substring(ext.lastIndexOf("."));
                        type = ext.substring(ext.lastIndexOf(".") + 1);
                    }
                    if (!MimeType.contains((String)type) && !ext.equals("/")) {
                        this.initializeFileURLPattern(ext);
                        mappingData.recycle();
                        adapter = this.map(req, decodedURI, mappingData);
                    } else {
                        super.service(req, res);
                        return;
                    }
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Request: " + decodedURI.toString() + " was mapped to Adapter: " + adapter);
                }
                if (adapter == null || adapter instanceof ContainerMapper) {
                    super.service(req, res);
                } else {
                    if (semicolon > 0 && end != 0) {
                        decodedURI.setBytes(uriBB.getBuffer(), start, end);
                        for (byte b : trailer) {
                            uriCC.append((char)b);
                        }
                    }
                    req.setNote(13, (Object)adapter);
                    ContextRootInfo contextRootInfo = null;
                    if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
                        contextRootInfo = (ContextRootInfo)mappingData.context;
                    }
                    if (contextRootInfo == null) {
                        adapter.service(req, res);
                    } else {
                        ClassLoader cl = null;
                        if (contextRootInfo.getContainer() instanceof ApplicationContainer) {
                            cl = ((ApplicationContainer)contextRootInfo.getContainer()).getClassLoader();
                        }
                        this.hk2Dispatcher.dispath(adapter, cl, req, res);
                    }
                }
            }
            catch (Exception ex) {
                try {
                    res.setStatus(500);
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Internal Server error: " + req.decodedURI(), ex);
                    }
                    this.customizedErrorPage(req, res);
                }
                catch (Exception ex2) {
                    if (!this.logger.isLoggable(Level.WARNING)) break block22;
                    this.logger.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public synchronized void initializeFileURLPattern(String ext) {
        for (Sniffer sniffer : this.grizzlyService.habitat.getAllByContract(Sniffer.class)) {
            boolean match = false;
            if (sniffer.getURLPatterns() == null) continue;
            for (String pattern : sniffer.getURLPatterns()) {
                if (!pattern.equalsIgnoreCase(ext)) continue;
                match = true;
                break;
            }
            ContainerMapper adapter = this;
            if (!match) continue;
            adapter = (Adapter)this.grizzlyService.habitat.getComponent(SnifferAdapter.class);
            ((SnifferAdapter)((Object)adapter)).initialize(sniffer, this);
            ContextRootInfo c = new ContextRootInfo((Adapter)adapter, null);
            for (String pattern : sniffer.getURLPatterns()) {
                for (String host : this.grizzlyService.hosts) {
                    this.mapper.addWrapper(host, ROOT, pattern, (Object)c, "*.jsp".equals(pattern) || "*.jspx".equals(pattern));
                }
            }
            return;
        }
    }

    Adapter map(Request req, MessageBytes decodedURI, MappingData mappingData) throws Exception {
        if (mappingData == null) {
            mappingData = (MappingData)req.getNote(12);
        }
        this.mapper.map(req.serverName(), decodedURI, mappingData);
        ContextRootInfo contextRootInfo = null;
        if (mappingData.context != null && (mappingData.context instanceof ContextRootInfo || mappingData.wrapper instanceof ContextRootInfo)) {
            contextRootInfo = mappingData.wrapper != null ? (ContextRootInfo)mappingData.wrapper : (ContextRootInfo)mappingData.context;
            return contextRootInfo.getAdapter();
        }
        if (mappingData.context != null && mappingData.context.getClass().getName().equals("com.sun.enterprise.web.WebModule")) {
            return ((V3Mapper)this.mapper).getAdapter();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterService(Request req, Response res) throws Exception {
        MappingData mappingData = (MappingData)req.getNote(12);
        try {
            Adapter adapter = (Adapter)req.getNote(13);
            if (adapter != null) {
                adapter.afterService(req, res);
            }
            super.afterService(req, res);
        }
        finally {
            req.setNote(13, null);
            if (mappingData != null) {
                mappingData.recycle();
            }
        }
    }

    protected void customizedErrorPage(Request req, Response res) throws Exception {
        ByteChunk chunk = new ByteChunk();
        chunk.setBytes(errorBody, 0, errorBody.length);
        res.setContentLength(errorBody.length);
        res.setContentType("text/html");
        res.sendHeaders();
        res.doWrite(chunk);
    }

    public void register(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER(" + (Object)((Object)this) + ") REGISTER contextRoot: " + contextRoot + " adapter: " + adapter + " container: " + container + " port: " + this.grizzlyEmbeddedHttp.getPort());
        }
        if (adapter.getClass().getName().equals("org.apache.catalina.connector.CoyoteAdapter")) {
            return;
        }
        this.mapMultipleAdapter = true;
        String ctx = this.getContextPath(contextRoot);
        String wrapper = this.getWrapperPath(ctx, contextRoot);
        ContextRootInfo c = new ContextRootInfo(adapter, (Object)container);
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, (Object)c, new String[0], null);
            if (!(adapter instanceof StaticResourcesAdapter)) continue;
            this.mapper.addWrapper(host, ctx, wrapper, (Object)c);
        }
    }

    private String getWrapperPath(String ctx, String mapping) {
        if (mapping.indexOf("*.") > 0) {
            return mapping.substring(mapping.lastIndexOf("/") + 1);
        }
        if (!ctx.equals(ROOT)) {
            return mapping.substring(ctx.length());
        }
        return mapping;
    }

    private String getContextPath(String mapping) {
        String ctx = ROOT;
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? ROOT : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = ROOT;
        }
        if (ctx.equals("/")) {
            ctx = ROOT;
        }
        return ctx;
    }

    public void unregister(String contextRoot) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER (" + (Object)((Object)this) + ") UNREGISTER contextRoot: " + contextRoot);
        }
        for (String host : this.grizzlyService.hosts) {
            this.mapper.removeContext(host, contextRoot);
        }
    }
}

