/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config.dom;

import com.sun.grizzly.config.dom.NetworkAddress;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolFinder;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface NetworkListener
extends ConfigBeanProxy,
Injectable,
PropertyBag {
    @Attribute(defaultValue="0.0.0.0")
    @NetworkAddress
    public String getAddress();

    public void setAddress(String var1);

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1);

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getJkEnabled();

    public void setJkEnabled(String var1);

    @Attribute(required=true, key=true)
    public String getName();

    public void setName(String var1);

    @Attribute(required=true, dataType=Integer.class)
    public String getPort();

    public void setPort(String var1);

    @DuckTyped
    public Protocol findProtocol();

    @DuckTyped
    public Protocol findHttpProtocol();

    @Attribute(required=true)
    public String getProtocol();

    public void setProtocol(String var1);

    @DuckTyped
    public ThreadPool findThreadPool();

    @Attribute
    public String getThreadPool();

    public void setThreadPool(String var1);

    @DuckTyped
    public Transport findTransport();

    @Attribute(required=true)
    public String getTransport();

    public void setTransport(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static Protocol findProtocol(NetworkListener listener) {
            String name = listener.getProtocol();
            NetworkConfig networkConfig = (NetworkConfig)listener.getParent().getParent(NetworkConfig.class);
            return networkConfig.findProtocol(name);
        }

        public static Protocol findHttpProtocol(NetworkListener listener) {
            NetworkConfig networkConfig = (NetworkConfig)listener.getParent().getParent(NetworkConfig.class);
            Protocol protocol = listener.findProtocol();
            return Duck.findHttpProtocol(new HashSet<String>(), networkConfig, protocol);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Protocol findHttpProtocol(Set<String> tray, NetworkConfig config, Protocol protocol) {
            String protocolName = protocol.getName();
            if (tray.contains(protocolName)) {
                throw new IllegalStateException("Loop found in Protocol definition. Protocol name: " + protocol.getName());
            }
            if (protocol.getHttp() != null) {
                return protocol;
            }
            if (protocol.getPortUnification() != null) {
                List<ProtocolFinder> finders = protocol.getPortUnification().getProtocolFinder();
                tray.add(protocolName);
                try {
                    Protocol foundHttpProtocol = null;
                    for (ProtocolFinder finder : finders) {
                        Protocol httpProtocol;
                        String subProtocolName = finder.getProtocol();
                        Protocol subProtocol = config.findProtocol(subProtocolName);
                        if (subProtocol == null || (httpProtocol = Duck.findHttpProtocol(tray, config, subProtocol)) == null) continue;
                        if (foundHttpProtocol == null) {
                            foundHttpProtocol = httpProtocol;
                            continue;
                        }
                        throw new IllegalStateException("Port unification allows only one \"<http>\" definition");
                    }
                    Protocol protocol2 = foundHttpProtocol;
                    return protocol2;
                }
                finally {
                    tray.remove(protocolName);
                }
            }
            return null;
        }

        public static ThreadPool findThreadPool(NetworkListener listener) {
            String name = listener.getThreadPool();
            for (ThreadPool threadPool : ConfigBean.unwrap((ConfigBeanProxy)listener).getHabitat().getAllByType(ThreadPool.class)) {
                if (!threadPool.getName().equals(name)) continue;
                return threadPool;
            }
            return null;
        }

        public static Transport findTransport(NetworkListener listener) {
            String name = listener.getTransport();
            NetworkConfig networkConfig = (NetworkConfig)listener.getParent().getParent(NetworkConfig.class);
            for (Transport transport : networkConfig.getTransports().getTransport()) {
                if (!transport.getName().equals(name)) continue;
                return transport;
            }
            return null;
        }
    }
}

