/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.HttpService;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.BaseLegacyConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class HttpServicePropertiesUpgrade
extends BaseLegacyConfigurationUpgrade {
    @Inject
    private HttpService service;

    public void execute(AdminCommandContext context) {
        boolean done = false;
        try {
            List<Property> properties = this.service.getProperty();
            Iterator<Property> iterator = properties.iterator();
            while (!done && iterator.hasNext()) {
                Property property = iterator.next();
                String name = property.getName();
                if (!"accessLoggingEnabled".equals(name) && !"accessLogBufferSize".equals(name) && !"accessLogWriteInterval".equals(name) && !"sso-enabled".equals(name)) continue;
                done = true;
                this.upgrade(context, property);
            }
        }
        catch (TransactionFailure tf) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading http-service properties.  Please check logs for errors", tf);
            throw new RuntimeException(tf);
        }
    }

    private void upgrade(AdminCommandContext context, final Property property) throws TransactionFailure {
        if ("accessLoggingEnabled".equals(property.getName())) {
            this.updatePropertyToAttribute(context, this.service, "accessLoggingEnabled", "accessLoggingEnabled");
        } else if ("accessLogBufferSize".equals(property.getName())) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AccessLog>(){

                public Object run(AccessLog param) {
                    param.setBufferSizeBytes(property.getValue());
                    return param;
                }
            }, (ConfigBeanProxy)this.service.getAccessLog());
            this.removeProperty(this.service, "accessLogBufferSize");
            this.report(context, "Moved http-service.property.accessLogBufferSize to http-service.access-log.buffer-size-bytes");
        } else if ("accessLogWriteInterval".equals(property.getName())) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AccessLog>(){

                public Object run(AccessLog param) {
                    param.setWriteIntervalSeconds(property.getValue());
                    return param;
                }
            }, (ConfigBeanProxy)this.service.getAccessLog());
            this.removeProperty(this.service, "accessLogWriteInterval");
            this.report(context, "Moved http-service.property.accessLogWriteInterval to http-service.access-log.write-interval-seconds");
        } else if ("sso-enabled".equals(property.getName())) {
            this.updatePropertyToAttribute(context, this.service, "sso-enabled", "ssoEnabled");
        }
    }
}

