/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.adapter.InstallerThread;
import com.sun.enterprise.v3.admin.adapter.Utils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyOutputBuffer;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.logging.LogDomains;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.Version;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class AdminConsoleAdapter
extends GrizzlyAdapter
implements Adapter,
PostConstruct,
EventListener {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    AdminService adminService;
    private String contextRoot;
    private File ipsRoot;
    private File warFile;
    private String proxyHost;
    private int proxyPort = 8080;
    private AdapterState stateMsg = AdapterState.UNINITIAZED;
    private boolean installing = false;
    private boolean isOK = false;
    private boolean errorOccurred = false;
    private String currentDeployedVersion = "";
    private String downloadedVersion = null;
    private final CountDownLatch latch = new CountDownLatch(1);
    @Inject
    private Logger log;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;
    @Inject
    volatile AdminService as = null;
    @Inject
    Events events;
    @Inject(name="server-config")
    Config serverConfig;
    AdminEndpointDecider epd;
    private String statusHtml;
    private String initHtml = Utils.packageResource2String("downloadgui.html");
    private boolean isRegistered = false;
    private ResourceBundle bundle;
    private static final String PROXY_HOST_PARAM = "proxyHost";
    private static final String PROXY_PORT_PARAM = "proxyPort";
    private static final String OK_PARAM = "ok";
    private static final String CANCEL_PARAM = "cancel";
    private static final String MYURL_TOKEN = "%%%MYURL%%%";
    private static final String STATUS_TOKEN = "%%%STATUS%%%";
    private static final String REDIRECT_TOKEN = "%%%LOCATION%%%";
    private static final String ADMIN_CONSOLE_IPS_PKGNAME = "glassfish-gui";
    private static final String RESOURCE_PACKAGE = "com/sun/enterprise/v3/admin/adapter";
    private static final String INSTALL_ROOT = "com.sun.aas.installRoot";
    static final String ADMIN_APP_NAME = "__admingui";
    private static final boolean directoryDeploy = true;

    public AdminConsoleAdapter() throws IOException {
        this.statusHtml = Utils.packageResource2String("status.html");
    }

    @Override
    public String getContextRoot() {
        return this.epd.getGuiContextRoot();
    }

    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        try {
            if (!this.latch.await(100L, TimeUnit.SECONDS)) {
                this.log.severe("Cannot process admin console request in time");
                return;
            }
        }
        catch (InterruptedException ex) {
            this.log.severe("Cannot process admin console request");
            return;
        }
        this.logRequest(req);
        if (this.isResourceRequest(req)) {
            block25: {
                try {
                    this.handleResourceRequest(req, res);
                }
                catch (IOException ioe) {
                    if (this.log.isLoggable(Level.SEVERE)) {
                        this.log.severe("Unable to serve resource: " + req.getRequestURI() + ".  Cause: " + ioe.toString());
                    }
                    if (!this.log.isLoggable(Level.FINE)) break block25;
                    this.log.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            return;
        }
        this.bundle = this.getResourceBundle(req.getLocale());
        res.setContentType("text/html; charset=UTF-8");
        if (this.isApplicationLoaded()) {
            this.handleLoadedState();
        } else {
            InteractionResult ir = this.getUserInteractionResult(req);
            if (ir == InteractionResult.CANCEL) {
                // empty if block
            }
            AdminConsoleAdapter adminConsoleAdapter = this;
            synchronized (adminConsoleAdapter) {
                if (this.downloadedVersion == null) {
                    this.setDownloadedVersion();
                }
                if (this.isInstalling()) {
                    this.sendStatusPage(req, res);
                } else {
                    if (this.isErrorOccurred()) {
                        this.restore();
                        this.sendStatusPage(req, res);
                        return;
                    }
                    if (this.isApplicationLoaded()) {
                        this.handleLoadedState();
                    } else if (!this.hasPermission(ir)) {
                        this.handleAuth(req, res);
                        this.sendConsentPage(req, res);
                    } else {
                        if (this.redeployNeeded()) {
                            this.setStateMsg(AdapterState.APPLICATION_PREPARE_UPGRADE);
                            this.sendStatusPage(req, res);
                            if (!this.prepareRedeploy()) {
                                this.setErrorOccurred(true);
                                this.sendStatusPage(req, res);
                                return;
                            }
                        }
                        try {
                            this.setInstalling(true);
                            this.startThread();
                        }
                        catch (Exception ex) {
                            this.setInstalling(false);
                            throw new RuntimeException("Unable to install Admin Console!", ex);
                        }
                        this.sendStatusPage(req, res);
                    }
                }
            }
        }
    }

    private boolean isResourceRequest(GrizzlyRequest req) {
        return this.getContentType(req.getRequestURI()) != null;
    }

    private String getContentType(String resource) {
        if (resource == null || resource.length() == 0) {
            return null;
        }
        if (resource.endsWith(".gif")) {
            return "image/gif";
        }
        if (resource.endsWith(".jpg")) {
            return "image/jpg";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Unhandled content-type: " + resource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceRequest(GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        String resourcePath = RESOURCE_PACKAGE + req.getRequestURI();
        ClassLoader loader = AdminConsoleAdapter.class.getClassLoader();
        InputStream in = null;
        try {
            in = loader.getResourceAsStream(resourcePath);
            if (in == null) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Resource not found: " + resourcePath);
                }
                return;
            }
            byte[] buf = new byte[512];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            int i = in.read(buf);
            while (i != -1) {
                baos.write(buf, 0, i);
                i = in.read(buf);
            }
            String contentType = this.getContentType(resourcePath);
            if (contentType != null) {
                res.setContentType(contentType);
            }
            res.setContentLength(baos.size());
            GrizzlyOutputStream out = res.getOutputStream();
            baos.writeTo((OutputStream)out);
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    private void setErrorOccurred(boolean error) {
        this.errorOccurred = error;
    }

    private boolean prepareRedeploy() {
        try {
            if (!this.stopAndCleanup()) {
                this.setStateMsg(AdapterState.APPLICATION_CLEANUP_FALED);
                return false;
            }
            File parentFile = this.warFile.getParentFile();
            File currentDeployedDir = new File(parentFile, ADMIN_APP_NAME);
            if (!currentDeployedDir.exists()) {
                this.logger.log(Level.WARNING, currentDeployedDir + " does not exist. Will not do backup for this.");
                return true;
            }
            File backupDir = new File(parentFile, "__admingui.backup");
            if (currentDeployedDir.renameTo(backupDir)) {
                return true;
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Exception in prepareRedeploy() " + ex.getMessage());
        }
        this.logger.log(Level.SEVERE, "Cannot backup previous version of __admingui ");
        this.setStateMsg(AdapterState.APPLICATION_BACKUP_FALED);
        return true;
    }

    private void restore() {
        this.setStateMsg(AdapterState.APPLICATION_RESTORE);
        File parentFile = this.warFile.getParentFile();
        File currentDeployedDir = new File(parentFile, ADMIN_APP_NAME);
        File backupDir = new File(parentFile, "__admingui.backup");
        backupDir.renameTo(currentDeployedDir);
        this.setStateMsg(AdapterState.APPLICATION_UPGRADE_FALED);
    }

    private boolean isApplicationLoaded() {
        return this.stateMsg == AdapterState.APPLICATION_LOADED;
    }

    boolean isInstalling() {
        return this.installing;
    }

    void setInstalling(boolean flag) {
        this.installing = flag;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    void setStateMsg(AdapterState msg) {
        this.stateMsg = msg;
        this.log.log(Level.INFO, (Object)((Object)msg) + "");
    }

    AdapterState getStateMsg() {
        return this.stateMsg;
    }

    public void postConstruct() {
        this.events.register(this);
        this.init();
    }

    @Override
    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        this.latch.countDown();
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "AdminConsoleAdapter is ready.");
        }
    }

    private void handleAuth(GrizzlyRequest greq, GrizzlyResponse gres) {
        try {
            AdminAccessController authenticator = (AdminAccessController)this.habitat.getByContract(AdminAccessController.class);
            if (authenticator != null) {
                String pswd;
                Request req = greq.getRequest();
                String[] userPass = AdminAdapter.getUserPassword(req);
                String string = pswd = userPass.length >= 2 ? userPass[1] : "";
                if (!authenticator.loginAsAdmin(userPass[0], pswd, this.as.getAuthRealmName())) {
                    this.setStateMsg(AdapterState.AUTHENTICATING);
                    gres.setStatus(401);
                    gres.addHeader("WWW-Authenticate", "BASIC");
                    gres.finishResponse();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void init() {
        Property iprop = this.adminService.getProperty("ipsRoot");
        if (iprop == null) {
            File f = new File(System.getProperty(INSTALL_ROOT));
            this.ipsRoot = new File(f, "..");
            this.writeAdminServiceProp("ipsRoot", "${com.sun.aas.installRoot}/..");
        } else {
            this.ipsRoot = new File(iprop.getValue());
        }
        Property locProp = this.adminService.getProperty("adminConsoleDownloadLocation");
        if (locProp == null || locProp.getValue() == null || locProp.getValue().equals("")) {
            String iRoot = System.getProperty(INSTALL_ROOT) + "/lib/install/applications/admingui.war";
            this.warFile = new File(iRoot.replace('/', File.separatorChar));
            this.writeAdminServiceProp("adminConsoleDownloadLocation", "${com.sun.aas.installRoot}/lib/install/applications/admingui.war");
        } else {
            String locValue = locProp.getValue();
            this.warFile = new File(locValue);
            if (!this.warFile.isAbsolute()) {
                File tmp = new File(System.getProperty(INSTALL_ROOT), "..");
                this.warFile = new File(tmp, locValue);
            }
        }
        Property prop = this.adminService.getProperty("adminConsoleVersion");
        this.currentDeployedVersion = prop != null ? prop.getValue() : "";
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "GlassFish IPS Root: " + this.ipsRoot.getAbsolutePath());
            this.log.log(Level.FINE, "Admin Console download location: " + this.warFile.getAbsolutePath());
            this.log.log(Level.FINE, "Current Deployed version: " + this.currentDeployedVersion);
        }
        this.initState();
        this.epd = new AdminEndpointDecider(this.serverConfig, this.log);
        this.contextRoot = this.epd.getGuiContextRoot();
    }

    private void initState() {
        if (this.appExistsInConfig()) {
            this.isOK = true;
            this.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        } else if (new File(this.warFile.getParentFile(), ADMIN_APP_NAME).exists() || this.warFile.exists()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.setStateMsg(AdapterState.DOWNLOADED);
            }
            this.isOK = true;
        } else {
            this.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
        }
    }

    private boolean appExistsInConfig() {
        return this.getConfig() != null;
    }

    Application getConfig() {
        Application app = this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), ADMIN_APP_NAME);
        return app;
    }

    private void logRequest(GrizzlyRequest req) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("AdminConsoleAdapter's STATE IS: " + (Object)((Object)this.getStateMsg()));
            this.log.log(Level.FINE, "Current Thread: " + Thread.currentThread().getName());
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String values = Arrays.toString(req.getParameterValues(name));
                this.log.fine("Parameter name: " + name + " values: " + values);
            }
        }
    }

    private boolean hasPermission(InteractionResult ir) {
        if (ir == InteractionResult.OK) {
            this.isOK = true;
        }
        return this.isOK;
    }

    private void startThread() {
        new InstallerThread(this.ipsRoot, this.warFile, this.proxyHost, this.proxyPort, this, this.habitat, this.domain, this.env, this.contextRoot, this.log, this.epd.getGuiHosts()).start();
    }

    private synchronized InteractionResult getUserInteractionResult(GrizzlyRequest req) {
        if (req.getParameter(OK_PARAM) != null) {
            this.proxyHost = req.getParameter(PROXY_HOST_PARAM);
            if (this.proxyHost != null && !this.proxyHost.equals("")) {
                String ps = req.getParameter(PROXY_PORT_PARAM);
                try {
                    this.proxyPort = Integer.parseInt(ps);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The specified proxy port (" + ps + ") must be a valid port integer!", nfe);
                }
            }
            this.setStateMsg(AdapterState.PERMISSION_GRANTED);
            this.isOK = true;
            return InteractionResult.OK;
        }
        if (req.getParameter(CANCEL_PARAM) != null) {
            this.setStateMsg(AdapterState.CANCELED);
            this.isOK = false;
            return InteractionResult.CANCEL;
        }
        return InteractionResult.FIRST_TIMER;
    }

    private GrizzlyOutputBuffer getOutputBuffer(GrizzlyResponse res) {
        GrizzlyOutputBuffer ob = res.getOutputBuffer();
        res.setStatus(202);
        res.setContentType("text/html");
        ob.setEncoding("UTF-8");
        return ob;
    }

    private synchronized void sendConsentPage(GrizzlyRequest req, GrizzlyResponse res) {
        this.setStateMsg(AdapterState.PERMISSION_NEEDED);
        try {
            byte[] bytes;
            GrizzlyOutputBuffer ob = this.getOutputBuffer(res);
            try {
                String localHtml = this.replaceTokens(this.initHtml, this.bundle);
                String hp = this.contextRoot.endsWith("/") ? this.contextRoot : this.contextRoot + "/";
                bytes = localHtml.replace(MYURL_TOKEN, hp).getBytes("UTF-8");
            }
            catch (Exception ex) {
                bytes = ("Catastrophe:" + ex.getMessage()).getBytes("UTF-8");
            }
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendStatusPage(GrizzlyRequest req, GrizzlyResponse res) {
        try {
            GrizzlyOutputBuffer ob = this.getOutputBuffer(res);
            String localHtml = this.replaceTokens(this.statusHtml, this.bundle);
            String status = this.getStateMsg().getI18NKey();
            try {
                status = this.bundle.getString(status);
            }
            catch (MissingResourceException ex) {
                status = this.getStateMsg().toString();
            }
            String locationUrl = req.getScheme() + "://" + req.getServerName() + ':' + req.getServerPort() + "/login.jsf";
            localHtml = localHtml.replace(REDIRECT_TOKEN, locationUrl);
            byte[] bytes = localHtml.replace(STATUS_TOKEN, status).getBytes("UTF-8");
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.sun.enterprise.v3.admin.adapter.LocalStrings", locale);
    }

    private String replaceTokens(String text, ResourceBundle bundle) {
        int start = 0;
        int end = 0;
        Object key = null;
        Object newString = null;
        StringBuffer buf = new StringBuffer("");
        Enumeration<String> keys = bundle.getKeys();
        while (start != -1) {
            start = text.indexOf("%%%", end);
            if (start == -1) continue;
            buf.append(text.substring(end, start));
            end = text.indexOf("%%%", start += 3);
            if (end != -1) {
                try {
                    buf.append(bundle.getString(text.substring(start, end)));
                }
                catch (MissingResourceException ex) {
                    buf.append("%%%" + text.substring(start, end) + "%%%");
                }
                end += 3;
                continue;
            }
            buf.append("%%%");
            end = start;
        }
        buf.append(text.substring(end));
        return buf.toString();
    }

    public String getDownloadedVersion() {
        return this.downloadedVersion;
    }

    public void setDownloadedVersion() {
        if (this.downloadedVersion == null) {
            this.downloadedVersion = "";
        }
        try {
            Image image = new Image(this.ipsRoot);
            if (image != null) {
                List fList = image.getInventory(new String[]{ADMIN_CONSOLE_IPS_PKGNAME}, false);
                if (fList.size() > 0) {
                    this.downloadedVersion = ((Image.FmriState)fList.get((int)0)).fmri.getVersion().toString();
                }
            } else {
                this.log.log(Level.WARNING, "!!!! No information relating to update center.");
            }
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "!!!!! Cannot create Update Center Image for " + this.ipsRoot);
        }
    }

    public String getCurrentDeployedVersion() {
        return this.currentDeployedVersion;
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public String getIPSPackageName() {
        return ADMIN_CONSOLE_IPS_PKGNAME;
    }

    private boolean redeployNeeded() {
        if (AdminConsoleAdapter.isDirectoryDeploy()) {
            return false;
        }
        if (this.currentDeployedVersion == null || this.currentDeployedVersion.equals("")) {
            return false;
        }
        if (this.downloadedVersion.equals("")) {
            return false;
        }
        Version deployed = new Version(this.currentDeployedVersion);
        Version downloaded = new Version(this.downloadedVersion);
        int compare = deployed.compareTo(downloaded);
        return compare == -1;
    }

    private void writeAdminServiceProp(final String propName, final String propValue) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AdminService>(){

                public Object run(AdminService adminService) throws PropertyVetoException, TransactionFailure {
                    Property newProp = (Property)adminService.createChild(Property.class);
                    adminService.getProperty().add(newProp);
                    newProp.setName(propName);
                    newProp.setValue(propValue);
                    return newProp;
                }
            }, (ConfigBeanProxy)this.adminService);
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "Cannot write property for AdminService in domain.xml; " + propName + ":" + propValue);
        }
    }

    public void updateDeployedVersion() {
        try {
            Property prop = this.adminService.getProperty("adminConsoleVersion");
            if (prop == null) {
                this.writeAdminServiceProp("adminConsoleVersion", this.downloadedVersion);
            } else if (!this.downloadedVersion.equals(prop.getValue())) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                    public Object run(Property prop) throws PropertyVetoException, TransactionFailure {
                        prop.setValue(AdminConsoleAdapter.this.downloadedVersion);
                        return prop;
                    }
                }, (ConfigBeanProxy)prop);
            }
        }
        catch (Exception ex) {
            this.log.log(Level.FINE, "!!!! Error, cannot update deployed version in domain.xml");
        }
    }

    private void handleLoadedState() {
        this.statusHtml = null;
        this.initHtml = null;
    }

    @Override
    public int getListenPort() {
        return this.epd.getListenPort();
    }

    @Override
    public List<String> getVirtualServers() {
        return this.epd.getGuiHosts();
    }

    private boolean stopAndCleanup() {
        Application app = this.getConfig();
        if (app == null) {
            return true;
        }
        String location = app.getLocation();
        Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.system.core");
        try {
            ArchiveFactory archiveFactory = (ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class);
            ReadableArchive archive = archiveFactory.openArchive(new File(location));
            UndeployCommandParameters parameters = new UndeployCommandParameters(ADMIN_APP_NAME);
            parameters.origin = OpsParams.Origin.unload;
            Deployment deployment = (Deployment)this.habitat.getComponent(Deployment.class);
            PlainTextActionReporter report = new PlainTextActionReporter();
            ExtendedDeploymentContext context = deployment.getBuilder(logger, (OpsParams)parameters, (ActionReport)report).source(archive).build();
            ApplicationInfo info = this.appRegistry.get(ADMIN_APP_NAME);
            if (info != null) {
                deployment.undeploy(ADMIN_APP_NAME, context);
            } else {
                context.clean();
            }
            if (((ActionReport)report).getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                logger.log(Level.SEVERE, "Cannot undeploy current admin gui ", ((ActionReport)report).getFailureCause());
                return false;
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception while stopping and cleaning previous instance of admin GUI", ioe);
            return false;
        }
        return true;
    }

    public static boolean isDirectoryDeploy() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InteractionResult {
        OK,
        CANCEL,
        FIRST_TIMER;

    }
}

