/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.StatsProvider;
import com.sun.grizzly.util.ExtendedThreadPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="connection-queue-mon", group="monitoring")
@ManagedObject
@Description(value="Connection Queue Statistics")
public class ConnectionQueueStatsProvider
implements StatsProvider {
    private static final long MINUTE = 60000L;
    private final String name;
    private final CountStatisticImpl countTotalConnections = new CountStatisticImpl("CountTotalConnections", "count", "Total number of connections that have been accepted");
    private final Map<Integer, Long> openConnectionsCount = new ConcurrentHashMap<Integer, Long>();
    private final CountStatisticImpl countOverflows = new CountStatisticImpl("CountOverflows", "count", "Number of times the queue has been too full to accommodate a connection");
    private final AtomicInteger countQueuedAtomic = new AtomicInteger();
    private final CountStatisticImpl countQueued = new CountStatisticImpl("CountQueued", "count", "Number of connections currently in the queue");
    private final CountStatisticImpl countTotalQueued = new CountStatisticImpl("CountTotalQueued", "count", "Total number of connections that have been queued");
    private final CountStatisticImpl maxQueued = new CountStatisticImpl("MaxQueued", "count", "Maximum size of the connection queue");
    private final AtomicInteger peakQueuedAtomic = new AtomicInteger();
    private final CountStatisticImpl peakQueued = new CountStatisticImpl("PeakQueued", "count", "Largest number of connections that were in the queue simultaneously");
    private final CountStatisticImpl ticksTotalQueued = new CountStatisticImpl("TicksTotalQueued", "count", "(Unsupported) Total number of ticks that connections have spent in the queue");
    private final int[] averageStatsPerMinute = new int[15];
    private long averageLastShift;
    private int averageMinuteCounter;
    private volatile ExtendedThreadPool threadPool;

    public ConnectionQueueStatsProvider(String name) {
        this.name = name;
    }

    public Object getStatsObject() {
        return this.threadPool;
    }

    public void setStatsObject(Object object) {
        this.threadPool = object instanceof ExtendedThreadPool ? (ExtendedThreadPool)object : null;
    }

    @ManagedAttribute(id="counttotalconnections")
    @Description(value="Total number of connections that have been accepted")
    public CountStatistic getTotalConnectionsCount() {
        return this.countTotalConnections;
    }

    @ManagedAttribute(id="countopenconnections")
    @Description(value="The number of open/active connections")
    public CountStatistic getOpenConnectionsCount() {
        CountStatisticImpl stats = new CountStatisticImpl("CountOpenConnections", "count", "The number of open/active connections");
        stats.setCount((long)this.openConnectionsCount.size());
        return stats;
    }

    @ManagedAttribute(id="countoverflows")
    @Description(value="Number of times the queue has been too full to accommodate a connection")
    public CountStatistic getCountOverflows() {
        return this.countOverflows;
    }

    @ManagedAttribute(id="countqueued")
    @Description(value="Number of connections currently in the queue")
    public CountStatistic getCountQueued() {
        return this.countQueued;
    }

    @ManagedAttribute(id="countqueued1minuteaverage")
    @Description(value="Average number of connections queued in the last 1 minute")
    public CountStatistic getCountQueued1MinuteAverage() {
        CountStatisticImpl stats = new CountStatisticImpl("CountQueued1MinuteAverage", "count", "Average number of connections queued in the last 1 minute");
        stats.setCount((long)this.getAverageBy(1));
        return stats;
    }

    @ManagedAttribute(id="countqueued5minutesaverage")
    @Description(value="Average number of connections queued in the last 5 minutes")
    public CountStatistic getCountQueued5MinutesAverage() {
        CountStatisticImpl stats = new CountStatisticImpl("CountQueued5MinutesAverage", "count", "Average number of connections queued in the last 5 minutes");
        stats.setCount((long)this.getAverageBy(5));
        return stats;
    }

    @ManagedAttribute(id="countqueued15minutesaverage")
    @Description(value="Average number of connections queued in the last 15 minutes")
    public CountStatistic getCountQueued15MinutesAverage() {
        CountStatisticImpl stats = new CountStatisticImpl("CountQueued15MinutesAverage", "count", "Average number of connections queued in the last 15 minutes");
        stats.setCount((long)this.getAverageBy(15));
        return stats;
    }

    @ManagedAttribute(id="counttotalqueued")
    @Description(value="Total number of connections that have been queued")
    public CountStatistic getCountTotalQueued() {
        return this.countTotalQueued;
    }

    @ManagedAttribute(id="maxqueued")
    @Description(value="Maximum size of the connection queue")
    public CountStatistic getMaxQueued() {
        return this.maxQueued;
    }

    @ManagedAttribute(id="peakqueued")
    @Description(value="Largest number of connections that were in the queue simultaneously")
    public CountStatistic getPeakQueued() {
        return this.peakQueued;
    }

    @ManagedAttribute(id="tickstotalqueued")
    @Description(value="(Unsupported) Total number of ticks that connections have spent in the queue")
    public CountStatistic getTicksTotalQueued() {
        return this.ticksTotalQueued;
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:connectionAcceptedEvent")
    public void connectionAcceptedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId, @ProbeParam(value="address") String address) {
        if (this.name.equals(listenerName)) {
            this.countTotalConnections.increment();
            this.openConnectionsCount.put(connectionId, System.currentTimeMillis());
        }
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:connectionClosedEvent")
    public void connectionClosedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId) {
        if (this.name.equals(listenerName)) {
            this.openConnectionsCount.remove(connectionId);
        }
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:setMaxTaskQueueSizeEvent")
    public void setMaxTaskQueueSizeEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="size") int size) {
        if (this.name.equals(listenerName)) {
            this.maxQueued.setCount((long)size);
        }
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:onTaskQueuedEvent")
    public void onTaskQueuedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="task") Runnable task) {
        if (this.name.equals(listenerName)) {
            int peakQueue;
            int queued = this.countQueuedAtomic.incrementAndGet();
            this.countQueued.setCount((long)queued);
            while (queued > (peakQueue = this.peakQueuedAtomic.get())) {
                if (!this.peakQueuedAtomic.compareAndSet(peakQueue, queued)) continue;
                this.peakQueued.setCount((long)queued);
                break;
            }
            this.countTotalQueued.increment();
            this.incAverageMinute();
        }
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:onTaskDequeuedEvent")
    public void onTaskDequeuedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="task") Runnable task) {
        if (this.name.equals(listenerName)) {
            this.countQueued.setCount((long)this.countQueuedAtomic.decrementAndGet());
        }
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:onTaskQueueOverflowEvent")
    public void onTaskQueueOverflowEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.countOverflows.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incAverageMinute() {
        int[] nArray = this.averageStatsPerMinute;
        synchronized (this.averageStatsPerMinute) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.averageLastShift >= 60000L) {
                this.shiftAverage(currentTime);
            }
            ++this.averageMinuteCounter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAverageBy(int mins) {
        int[] nArray = this.averageStatsPerMinute;
        synchronized (this.averageStatsPerMinute) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.averageLastShift >= 60000L) {
                this.shiftAverage(currentTime);
            }
            int result = this.averageMinuteCounter;
            int statsToCount = Math.min(mins - 1, this.averageStatsPerMinute.length);
            for (int i = 0; i < statsToCount; ++i) {
                result += this.averageStatsPerMinute[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private void shiftAverage(long currentTime) {
        int shift = (int)((currentTime - this.averageLastShift) / 60000L);
        if (shift == 0) {
            return;
        }
        int statsSize = this.averageStatsPerMinute.length;
        for (int i = statsSize - 1; i >= 0; --i) {
            int newIndex = shift + i;
            if (newIndex < statsSize) {
                this.averageStatsPerMinute[newIndex] = this.averageStatsPerMinute[i];
            }
            this.averageStatsPerMinute[i] = 0;
        }
        if (shift <= statsSize) {
            this.averageStatsPerMinute[shift - 1] = this.averageMinuteCounter;
        }
        this.averageMinuteCounter = 0;
        this.averageLastShift += (long)shift * 60000L;
    }

    @Reset
    public void reset() {
        this.countTotalConnections.setCount(0L);
        this.openConnectionsCount.clear();
        this.countOverflows.setCount(0L);
        this.countQueuedAtomic.set(0);
        this.countQueued.setCount(0L);
        this.countTotalQueued.setCount(0L);
        ExtendedThreadPool threadPoolObject = this.threadPool;
        if (threadPoolObject != null) {
            this.maxQueued.setCount((long)threadPoolObject.getMaxQueuedTasksCount());
        }
        this.peakQueuedAtomic.set(0);
        this.peakQueued.setCount(0L);
        this.ticksTotalQueued.setCount(0L);
        this.averageLastShift = 0L;
        this.averageMinuteCounter = 0;
        for (int i = 0; i < this.averageStatsPerMinute.length; ++i) {
            this.averageStatsPerMinute[i] = 0;
        }
    }
}

