/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.logging.LogDomains;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.DTraceContract;
import org.glassfish.api.monitoring.ProbeProviderInfo;
import org.glassfish.external.probe.provider.annotations.ProbeProvider;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.impl.client.FlashlightProbeClientMediator;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.impl.core.ProbeFactory;
import org.glassfish.flashlight.impl.core.ProbeProviderRegistry;
import org.glassfish.flashlight.impl.core.ProviderImplGenerator;
import org.glassfish.flashlight.impl.provider.DTraceMethodFinder;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.xml.Probe;
import org.glassfish.flashlight.xml.ProbeParam;
import org.glassfish.flashlight.xml.ProbeProviderStaxParser;
import org.glassfish.flashlight.xml.Provider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeProviderFactory
implements ProbeProviderFactory,
PostConstruct {
    @Inject
    MonitoringService monitoringServiceConfig;
    @Inject
    ProbeProviderEventManager ppem;
    @Inject
    Habitat habitat;
    private static final Set<FlashlightProbeProvider> allProbeProviders = new HashSet<FlashlightProbeProvider>();
    private static final Logger logger = LogDomains.getLogger(FlashlightProbeProviderFactory.class, (String)"javax.enterprise.system.tools.monitor");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlashlightProbeProviderFactory.class);
    private final HashMap<String, Class> primTypes = new HashMap<String, Class>(){
        {
            this.put("int", Integer.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("char", Character.TYPE);
            this.put("short", Short.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("void", Void.TYPE);
        }
    };

    public void postConstruct() {
        FlashlightUtils.initialize(this.habitat, this.monitoringServiceConfig);
    }

    @Override
    public void dtraceEnabledChanged(boolean newValue) {
        FlashlightUtils.setDTraceEnabled(newValue);
        if (!newValue) {
            return;
        }
        if (!FlashlightUtils.isDtraceAvailable()) {
            return;
        }
        Collection<FlashlightProbeProvider> pps = ProbeProviderRegistry.getInstance().getAllProbeProviders();
        for (FlashlightProbeProvider pp : pps) {
            if (pp.isDTraceInstrumented()) continue;
            this.handleDTrace(pp);
        }
    }

    @Override
    public void monitoringEnabledChanged(boolean newValue) {
        FlashlightUtils.setMonitoringEnabled(newValue);
        if (newValue && FlashlightUtils.isDtraceEnabled()) {
            this.dtraceEnabledChanged(true);
        }
    }

    @Override
    public <T> T getProbeProvider(Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        ProbeProvider provAnn = providerClazz.getAnnotation(ProbeProvider.class);
        String moduleProviderName = provAnn.moduleProviderName();
        String moduleName = provAnn.moduleName();
        String probeProviderName = provAnn.probeProviderName();
        if (this.isValidString(moduleProviderName) && this.isValidString(moduleName) && this.isValidString(probeProviderName)) {
            return this.getProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        }
        logger.log(Level.WARNING, localStrings.getLocalString("invalidProbeProvider", "Invalid parameters for ProbeProvider, ignoring {0}", new Object[]{providerClazz.getName()}));
        return null;
    }

    @Override
    public <T> T getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName, Class<T> providerClazz) throws InstantiationException, IllegalAccessException {
        FlashlightProbeProvider alreadyExists;
        ProbeProviderRegistry ppRegistry = ProbeProviderRegistry.getInstance();
        FlashlightProbeProvider provider = null;
        provider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("ModuleProviderName= " + moduleProviderName + " \tModule= " + moduleName + "\tProbeProviderName= " + probeProviderName + "\tProviderClazz= " + providerClazz.toString());
        }
        if ((alreadyExists = ppRegistry.getProbeProvider(provider)) != null) {
            Object inst = alreadyExists.getProviderClass().newInstance();
            return inst;
        }
        List<Method> methods = FlashlightUtils.getProbeMethods(providerClazz);
        for (Method m : methods) {
            int sz = m.getParameterTypes().length;
            org.glassfish.external.probe.provider.annotations.Probe pnameAnn = m.getAnnotation(org.glassfish.external.probe.provider.annotations.Probe.class);
            String probeName = pnameAnn != null ? pnameAnn.name() : m.getName();
            boolean self = pnameAnn != null ? pnameAnn.self() : false;
            boolean hidden = pnameAnn != null ? pnameAnn.hidden() : false;
            String[] probeParamNames = FlashlightUtils.getParamNames(m);
            FlashlightProbe probe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParamNames, m.getParameterTypes(), self, hidden);
            probe.setProviderJavaMethodName(m.getName());
            provider.addProbe(probe);
        }
        this.handleDTrace(provider);
        Class<Object> tClazz = providerClazz;
        int mod = providerClazz.getModifiers();
        if (Modifier.isAbstract(mod)) {
            String generatedClassName = provider.getModuleProviderName() + "_Flashlight_" + provider.getModuleName() + "_" + "Probe_" + (provider.getProbeProviderName() == null ? providerClazz.getName() : provider.getProbeProviderName());
            generatedClassName = providerClazz.getName() + "_" + generatedClassName;
            try {
                tClazz = providerClazz.getClassLoader().loadClass(generatedClassName);
                return (T)tClazz.newInstance();
            }
            catch (ClassNotFoundException cnfEx) {
                ProviderImplGenerator gen = new ProviderImplGenerator();
                generatedClassName = gen.defineClass(provider, providerClazz);
                try {
                    tClazz = providerClazz.getClassLoader().loadClass(generatedClassName);
                }
                catch (ClassNotFoundException cnfEx2) {
                    throw new RuntimeException(cnfEx2);
                }
            }
        }
        ppRegistry.getInstance().registerProbeProvider(provider, tClazz);
        T inst = tClazz.newInstance();
        return inst;
    }

    @Override
    public void processXMLProbeProviders(ClassLoader cl, String xml, boolean inBundle) {
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("processProbeProviderXML for " + xml);
        }
        try {
            InputStream is = cl.getResourceAsStream(xml);
            is = inBundle ? cl.getResourceAsStream(xml) : new FileInputStream(xml);
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("InputStream = " + is);
            }
            ProbeProviderStaxParser providerXMLParser = new ProbeProviderStaxParser(is);
            List<Provider> providers = providerXMLParser.getProviders();
            for (Provider provider : providers) {
                if (logger.isLoggable(Level.FINEST)) {
                    this.printd(provider.toString());
                }
                this.registerProvider(cl, provider);
            }
        }
        catch (Exception e) {
            String errStr = localStrings.getLocalString("cannotProcessXMLProbeProvider", "Cannot process XML ProbeProvider, xml = {0}", new Object[]{xml});
            logger.log(Level.SEVERE, errStr, e);
        }
    }

    public String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    private void handleDTrace(FlashlightProbeProvider provider) {
        DTraceContract dt = FlashlightUtils.getDtraceEngine();
        if (dt == null) {
            return;
        }
        Object dtraceProviderImpl = dt.getProvider((ProbeProviderInfo)provider);
        if (dtraceProviderImpl == null) {
            provider.setDTraceInstrumented(false);
            return;
        }
        provider.setDTraceInstrumented(true);
        Collection<FlashlightProbe> probes = provider.getProbes();
        for (FlashlightProbe probe : probes) {
            DTraceMethodFinder mf = new DTraceMethodFinder(probe, dtraceProviderImpl);
            probe.setDTraceMethod(mf.matchMethod());
            probe.setDTraceProviderImpl(dtraceProviderImpl);
        }
        FlashlightProbeClientMediator.getInstance().registerDTraceListener(provider);
    }

    private void registerProvider(ClassLoader cl, Provider provider) {
        String moduleProviderName = provider.getModuleProviderName();
        String moduleName = provider.getModuleName();
        String probeProviderName = provider.getProbeProviderName();
        String providerClass = provider.getProbeProviderClass();
        List<Probe> probes = provider.getProbes();
        Class<?> providerClazz = null;
        try {
            providerClazz = cl.loadClass(providerClass);
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("providerClazz = " + providerClazz);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(" Could not load the class ( " + providerClazz + " ) for the provider " + providerClass);
            }
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("moduleProviderName = " + moduleProviderName);
            this.printd("moduleName = " + moduleName);
            this.printd("probeProviderName = " + probeProviderName);
            this.printd("probeProviderClass = " + providerClass);
        }
        FlashlightProbeProvider flProvider = new FlashlightProbeProvider(moduleProviderName, moduleName, probeProviderName, providerClazz);
        for (Probe probe : probes) {
            String probeName = probe.getProbeName();
            String probeMethod = probe.getProbeMethod();
            boolean hasSelf = probe.hasSelf();
            boolean isHidden = probe.isHidden();
            boolean errorParsingProbe = false;
            String[] probeParams = new String[probe.getProbeParams().size()];
            Class[] paramTypes = new Class[probe.getProbeParams().size()];
            int i = 0;
            for (ProbeParam param : probe.getProbeParams()) {
                probeParams[i] = param.getName();
                if (logger.isLoggable(Level.FINEST)) {
                    this.printd("          probeParam[" + i + "] = " + probeParams[i]);
                }
                paramTypes[i] = this.getParamType(cl, param.getType());
                if (paramTypes[i] == null) {
                    errorParsingProbe = true;
                    String errStr = localStrings.getLocalString("cannotResolveProbeParamTypes", "Cannot resolve the paramTypes, unable to create this probe - {0}", new Object[]{probeName});
                    logger.log(Level.SEVERE, errStr);
                    break;
                }
                ++i;
            }
            if (errorParsingProbe) {
                errorParsingProbe = false;
                continue;
            }
            FlashlightProbe flProbe = ProbeFactory.createProbe(providerClazz, moduleProviderName, moduleName, probeProviderName, probeName, probeParams, paramTypes, hasSelf, isHidden);
            flProbe.setProviderJavaMethodName(probeMethod);
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(" Constructed probe = " + flProbe.toString());
            }
            flProvider.addProbe(flProbe);
        }
        if (flProvider.getProbes().size() == 0) {
            return;
        }
        this.handleDTrace(flProvider);
        allProbeProviders.add(flProvider);
        ProbeProviderRegistry.getInstance().registerProbeProvider(flProvider, providerClazz);
        if (logger.isLoggable(Level.FINEST)) {
            this.printd(" Provider registered successfully - " + probeProviderName);
        }
    }

    private Class<?> getParamType(ClassLoader cl, String paramTypeStr) {
        Class<?> paramType = null;
        try {
            Class primType = this.primTypes.get(paramTypeStr);
            if (primType != null) {
                return primType;
            }
            paramType = cl.loadClass(paramTypeStr);
        }
        catch (ClassNotFoundException ex) {
            try {
                paramType = cl.loadClass("java.lang." + paramTypeStr);
            }
            catch (Exception e) {
                String errStr = localStrings.getLocalString("cannotResolveProbeParamTypes", "Cannot resolve the paramTypes of the probe - {0}, Try giving a fully qualified name for the type", new Object[]{paramTypeStr});
                logger.log(Level.SEVERE, errStr, e);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("          paramType = " + paramType);
        }
        return paramType;
    }

    private void printd(String pstring) {
        logger.log(Level.FINEST, pstring);
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }
}

