/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.listener;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class SystemPropertyListener
implements ConfigListener,
PostConstruct {
    Logger logger = LogDomains.getLogger(SystemPropertyListener.class, (String)"javax.enterprise.system.tools.admin");
    @Inject
    private volatile Domain domain;

    public void postConstruct() {
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                if (changedType == SystemProperty.class && type == Changed.TYPE.ADD) {
                    SystemProperty sp = (SystemProperty)changedInstance;
                    if (sp.getParent() instanceof Domain) {
                        return SystemPropertyListener.this.addToDomain(sp);
                    }
                    return SystemPropertyListener.this.addToServer(sp);
                }
                if (changedType == SystemProperty.class && type == Changed.TYPE.REMOVE) {
                    SystemProperty sp = (SystemProperty)changedInstance;
                    if (sp.getParent() instanceof Domain) {
                        return SystemPropertyListener.this.removeFromDomain(sp);
                    }
                    return SystemPropertyListener.this.removeFromServer(sp);
                }
                if (changedType == SystemProperty.class && type == Changed.TYPE.CHANGE) {
                    SystemProperty sp = (SystemProperty)changedInstance;
                    if (sp.getParent() instanceof Domain) {
                        return SystemPropertyListener.this.addToDomain(sp);
                    }
                    return SystemPropertyListener.this.addToServer(sp);
                }
                return null;
            }
        }, (Logger)this.logger);
    }

    private NotProcessed removeFromServer(SystemProperty sp) {
        System.clearProperty(sp.getName());
        return null;
    }

    private NotProcessed removeFromDomain(SystemProperty sp) {
        if (!this.serverHas(sp)) {
            System.clearProperty(sp.getName());
        }
        return null;
    }

    private NotProcessed addToServer(SystemProperty sp) {
        System.setProperty(sp.getName(), sp.getValue());
        return null;
    }

    private NotProcessed addToDomain(SystemProperty sp) {
        if (!this.serverHas(sp)) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private boolean serverHas(SystemProperty sp) {
        Server s = this.domain.getServerNamed("server");
        List ssps = s.getSystemProperty();
        if (ssps != null) {
            for (SystemProperty candidate : ssps) {
                if (!candidate.getName().equals(sp.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

