/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.universal.GFBase64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.ParamTokenizer;
import com.sun.enterprise.v3.admin.UnacceptableValueException;
import com.sun.enterprise.v3.common.XMLContentActionReporter;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.config.support.CommandModelImpl;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.UnsatisfiedDepedencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CommandRunnerImpl
implements CommandRunner {
    private final Logger logger = LogDomains.getLogger(CommandRunnerImpl.class, (String)"javax.enterprise.system.tools.admin");
    private final InjectionManager injectionMgr = new InjectionManager();
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext sc;
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunnerImpl.class);

    @Override
    public ActionReport getActionReport(String name) {
        return (ActionReport)this.habitat.getComponent(ActionReport.class, name);
    }

    @Override
    public CommandModel getModel(String commandName, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot instantiate " + commandName, e);
            return null;
        }
        return CommandRunnerImpl.getModel(command);
    }

    @Override
    public AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            e.printStackTrace();
            report.setFailureCause(e);
        }
        if (command == null) {
            String msg = !CommandRunnerImpl.ok(commandName) ? adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.") : (this.habitat.getInhabitant(AdminCommand.class, commandName) == null ? adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName}) : adminStrings.getLocalString("adapter.command.notcreated", "Implementation for the command {0} exists in the system, but it has some errors, check server.log for details", new Object[]{commandName}));
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
        }
        return command;
    }

    @Override
    public CommandRunner.CommandInvocation getCommandInvocation(String name, ActionReport report) {
        return new ExecutionContext(name, report);
    }

    private ActionReport doCommand(CommandModel model, final AdminCommand command, InjectionResolver<Param> injector, ActionReport report, Payload.Inbound inboundPayload, Payload.Outbound outboundPayload) {
        report.setActionDescription(model.getCommandName() + " AdminCommand");
        final AdminCommandContext context = new AdminCommandContext(LogDomains.getLogger(command.getClass(), (String)"javax.enterprise.system.tools.admin"), report, inboundPayload, outboundPayload);
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = model.getI18n();
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        try {
            this.injectionMgr.inject((Object)command, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDepedencyException e) {
            String errorMsg;
            Param param = (Param)e.getAnnotation(Param.class);
            CommandModel.ParamModel paramModel = null;
            for (CommandModel.ParamModel pModel : model.getParameters()) {
                if (!pModel.getParam().equals(param)) continue;
                paramModel = pModel;
                break;
            }
            String usage = CommandRunnerImpl.getUsageText(command, model);
            if (paramModel != null) {
                String paramName = paramModel.getName();
                String paramDesc = CommandRunnerImpl.getParamDescription(localStrings, i18n_key, paramModel);
                errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", new Object[]{model.getCommandName(), paramName}) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter ({2})", new Object[]{model.getCommandName(), paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{model.getCommandName(), paramName})));
            } else {
                errorMsg = adminStrings.getLocalString("admin.param.missing.nofound", "Cannot find {1} in {0} command model, file a bug", new Object[]{model.getCommandName(), e.getUnsatisfiedName()});
            }
            this.logger.severe(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause(e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return report;
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof UnacceptableValueException || cause instanceof IllegalArgumentException)) {
                exception = (Exception)cause;
            }
            this.logger.log(Level.SEVERE, "invocation.exception", exception);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(CommandRunnerImpl.getUsageText(command, model));
            return report;
        }
        final AdminCommand wrappedComamnd = new AdminCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AdminCommandContext context) {
                ClassLoader ccl;
                Thread thread = Thread.currentThread();
                ClassLoader origCL = thread.getContextClassLoader();
                if (origCL != (ccl = CommandRunnerImpl.this.sc.getCommonClassLoader())) {
                    try {
                        thread.setContextClassLoader(ccl);
                        command.execute(context);
                    }
                    finally {
                        thread.setContextClassLoader(origCL);
                    }
                } else {
                    command.execute(context);
                }
            }
        };
        Async async = command.getClass().getAnnotation(Async.class);
        if (async == null) {
            try {
                wrappedComamnd.execute(context);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, adminStrings.getLocalString("adapter.exception", "Exception in command execution : ", new Object[]{e}), e);
                report.setMessage(e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
            }
        } else {
            Thread t = new Thread(){

                public void run() {
                    try {
                        wrappedComamnd.execute(context);
                    }
                    catch (RuntimeException e) {
                        CommandRunnerImpl.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            t.setPriority(async.priority());
            t.start();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(adminStrings.getLocalString("adapter.command.launch", "Command {0} was successfully initiated asynchronously.", new Object[]{model.getCommandName()}));
        }
        return context.getActionReport();
    }

    private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
        Param param = target.getAnnotation(Param.class);
        String acceptable = param.acceptableValues();
        String paramName = CommandRunnerImpl.getParamName(param, target);
        if (CommandRunnerImpl.ok(acceptable) && CommandRunnerImpl.ok(paramValueStr)) {
            String[] ss = acceptable.split(",");
            boolean ok = false;
            for (String s : ss) {
                if (!paramValueStr.equals(s.trim())) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
            }
        }
    }

    private static String getParamDescription(LocalStringManagerImpl localStrings, String i18nKey, CommandModel.ParamModel model) {
        I18n i18n = model.getI18n();
        String paramDesc = i18n == null ? localStrings.getLocalString(i18nKey + "." + model.getName(), "") : localStrings.getLocalString(i18n.value(), "");
        if (paramDesc == null) {
            paramDesc = "";
        }
        return paramDesc;
    }

    private static String getParamName(Param param, AnnotatedElement annotated) {
        if (param.name().equals("")) {
            if (annotated instanceof Field) {
                return ((Field)annotated).getName();
            }
            if (annotated instanceof Method) {
                return ((Method)annotated).getName().substring(3).toLowerCase();
            }
        } else {
            if (param.password()) {
                return ASADMIN_CMD_PREFIX + param.name().toUpperCase(Locale.ENGLISH);
            }
            return param.name();
        }
        return "";
    }

    static String getParamValueString(ParameterMap parameters, Param param, AnnotatedElement target) {
        String paramValueStr = CommandRunnerImpl.getParameterValue(parameters, CommandRunnerImpl.getParamName(param, target), true);
        if (paramValueStr == null) {
            paramValueStr = (String)parameters.getOne(param.shortName());
        }
        if (paramValueStr == null && param.password()) {
            paramValueStr = CommandRunnerImpl.getParameterValue(parameters, param.name(), true);
        }
        if (paramValueStr == null) {
            String defaultValue = param.defaultValue();
            paramValueStr = defaultValue.equals("") ? null : defaultValue;
        }
        return paramValueStr;
    }

    static Object getParamField(Object component, AnnotatedElement annotated) {
        try {
            if (annotated instanceof Field) {
                Field field = (Field)annotated;
                field.setAccessible(true);
                return ((Field)annotated).get(component);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getParameterValue(ParameterMap params, String key, boolean ignoreCase) {
        if (ignoreCase) {
            for (Map.Entry entry : params.entrySet()) {
                String paramName = (String)entry.getKey();
                if (!paramName.equalsIgnoreCase(key)) continue;
                if (paramName.startsWith(ASADMIN_CMD_PREFIX)) {
                    try {
                        GFBase64Decoder base64Decoder = new GFBase64Decoder();
                        return new String(base64Decoder.decodeBuffer((String)((List)entry.getValue()).get(0)));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return (String)((List)entry.getValue()).get(0);
            }
        }
        return (String)params.getOne(key);
    }

    static String getUsageText(AdminCommand command, CommandModel model) {
        String usage;
        StringBuffer usageText = new StringBuffer();
        I18n i18n = model.getI18n();
        String i18nKey = null;
        LocalStringManagerImpl lsm = new LocalStringManagerImpl(command.getClass());
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (i18nKey != null && CommandRunnerImpl.ok(usage = lsm.getLocalString(i18nKey + ".usagetext", ""))) {
            usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
            usageText.append(usage);
            return usageText.toString();
        }
        return CommandRunnerImpl.generateUsageText(model);
    }

    private static String generateUsageText(CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
        usageText.append(model.getCommandName());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (CommandModel.ParamModel pModel : model.getParameters()) {
            Param param = pModel.getParam();
            String paramName = pModel.getName();
            if (param.password()) continue;
            boolean optional = param.optional();
            Class ftype = pModel.getType();
            String fvalue = null;
            String fvalueString = null;
            try {
                fvalue = param.defaultValue();
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
            } else if (ftype.isAssignableFrom(String.class)) {
                if (CommandRunnerImpl.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                } else {
                    usageText.append("=").append(paramName);
                }
            } else if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
            } else {
                usageText.append("=").append(paramName);
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    public void getHelp(AdminCommand command, ActionReport report) {
        CommandModel model = CommandRunnerImpl.getModel(command);
        report.setActionDescription(model.getCommandName() + " help");
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18nKey = "";
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (report instanceof XMLContentActionReporter) {
            this.getMetadata(command, model, report);
        } else {
            report.setMessage(model.getCommandName() + " - " + localStrings.getLocalString(i18nKey, ""));
            report.getTopMessagePart().addProperty("SYNOPSIS", CommandRunnerImpl.getUsageText(command, model));
            for (CommandModel.ParamModel param : model.getParameters()) {
                this.addParamUsage(report, localStrings, i18nKey, param);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void getMetadata(AdminCommand command, CommandModel model, ActionReport report) {
        String usage;
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = model.getI18n();
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        ActionReport.MessagePart top = report.getTopMessagePart();
        ActionReport.MessagePart cmd = top.addChild();
        cmd.setChildrenType("command");
        cmd.addProperty("name", model.getCommandName());
        if (model.unknownOptionsAreOperands()) {
            cmd.addProperty("unknown-options-are-operands", "true");
        }
        if (CommandRunnerImpl.ok(usage = localStrings.getLocalString(i18n_key + ".usagetext", ""))) {
            cmd.addProperty("usage", usage);
        }
        CommandModel.ParamModel primary = null;
        for (CommandModel.ParamModel p : model.getParameters()) {
            Param param = p.getParam();
            if (param.primary()) {
                primary = p;
                continue;
            }
            ActionReport.MessagePart ppart = cmd.addChild();
            ppart.setChildrenType("option");
            ppart.addProperty("name", p.getName());
            ppart.addProperty("type", CommandRunnerImpl.typeOf(p));
            ppart.addProperty("optional", Boolean.toString(param.optional()));
            String paramDesc = CommandRunnerImpl.getParamDescription(localStrings, i18n_key, p);
            if (CommandRunnerImpl.ok(paramDesc)) {
                ppart.addProperty("description", paramDesc);
            }
            if (CommandRunnerImpl.ok(param.shortName())) {
                ppart.addProperty("short", param.shortName());
            }
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                ppart.addProperty("default", param.defaultValue());
            }
            if (!CommandRunnerImpl.ok(param.acceptableValues())) continue;
            ppart.addProperty("acceptable-values", param.acceptableValues());
        }
        if (primary != null) {
            ActionReport.MessagePart primpart = cmd.addChild();
            primpart.setChildrenType("operand");
            primpart.addProperty("name", primary.getName());
            primpart.addProperty("type", CommandRunnerImpl.typeOf(primary));
            primpart.addProperty("min", primary.getParam().optional() ? "0" : "1");
            primpart.addProperty("max", primary.getParam().multiple() ? Integer.toString(Integer.MAX_VALUE) : "1");
            String desc = CommandRunnerImpl.getParamDescription(localStrings, i18n_key, primary);
            if (CommandRunnerImpl.ok(desc)) {
                primpart.addProperty("description", desc);
            }
        }
    }

    private static String typeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class) {
            return "BOOLEAN";
        }
        if (t == File.class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }

    public InputStream getManPage(String commandName, AdminCommand command) {
        Class<?> clazz = command.getClass();
        Package pkg = clazz.getPackage();
        String manPage = pkg.getName().replace('.', '/');
        manPage = manPage + "/" + commandName + ".1";
        ClassLoader loader = clazz.getClassLoader();
        InputStream in = loader.getResourceAsStream(manPage);
        return in;
    }

    private void addParamUsage(ActionReport report, LocalStringManagerImpl localStrings, String i18nKey, CommandModel.ParamModel model) {
        Param param = model.getParam();
        if (param != null) {
            String paramName = model.getName();
            if (param.primary()) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", CommandRunnerImpl.getParamDescription(localStrings, i18nKey, model));
            } else {
                report.getTopMessagePart().addProperty(paramName, CommandRunnerImpl.getParamDescription(localStrings, i18nKey, model));
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static void validateParameters(CommandModel model, ParameterMap parameters) throws ComponentException {
        for (Map.Entry entry : parameters.entrySet()) {
            CommandModel.ParamModel pModel;
            String key = (String)entry.getKey();
            if (key.equals("DEFAULT") || key.startsWith(ASADMIN_CMD_PREFIX) || key.equals("help") || key.equals("Xhelp")) continue;
            boolean validOption = false;
            Iterator<CommandModel.ParamModel> i$ = model.getParameters().iterator();
            while (!(!i$.hasNext() || (validOption = (pModel = i$.next()).isParamId(key)) || pModel.getParam().password() && (validOption = pModel.isParamId(ASADMIN_CMD_PREFIX + key.toUpperCase(Locale.ENGLISH))))) {
            }
            if (validOption) continue;
            throw new ComponentException(" Invalid option: " + key);
        }
    }

    static Object convertStringToObject(AnnotatedElement target, Class type, String paramValStr) {
        Param param = target.getAnnotation(Param.class);
        String[] paramValue = paramValStr;
        if (type.isAssignableFrom(String.class)) {
            paramValue = paramValStr;
        } else if (type.isAssignableFrom(Properties.class)) {
            paramValue = CommandRunnerImpl.convertStringToProperties(paramValStr, param.separator());
        } else if (type.isAssignableFrom(List.class)) {
            paramValue = CommandRunnerImpl.convertStringToList(paramValStr, param.separator());
        } else if (type.isAssignableFrom(Boolean.class)) {
            String paramName = CommandRunnerImpl.getParamName(param, target);
            paramValue = CommandRunnerImpl.convertStringToBoolean(paramName, paramValStr);
        } else if (type.isAssignableFrom(String[].class)) {
            paramValue = CommandRunnerImpl.convertStringToStringArray(paramValStr, param.separator());
        } else if (type.isAssignableFrom(File.class)) {
            return new File(paramValStr);
        }
        return paramValue;
    }

    static Object convertListToObject(AnnotatedElement target, Class type, List<String> paramValList) {
        Param param = target.getAnnotation(Param.class);
        if (!param.multiple()) {
            if (paramValList.size() == 1) {
                return CommandRunnerImpl.convertStringToObject(target, type, paramValList.get(0));
            }
            throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.tooManyValues", "Invalid parameter: {0}.  This parameter may not have more than one value.", new Object[]{CommandRunnerImpl.getParamName(param, target)}));
        }
        Object paramValue = paramValList;
        if (!type.isAssignableFrom(List.class)) {
            if (type.isAssignableFrom(String[].class)) {
                paramValue = paramValList.toArray(new String[paramValList.size()]);
            } else if (type.isAssignableFrom(Properties.class)) {
                paramValue = CommandRunnerImpl.convertListToProperties((List<String>)paramValList);
            }
        }
        return paramValue;
    }

    private static Boolean convertStringToBoolean(String paramName, String s) {
        if (!CommandRunnerImpl.ok(s)) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        String msg = adminStrings.getLocalString("adapter.command.unacceptableBooleanValue", "Invalid parameter: {0}.  This boolean option must be set (case insensitive) to true or false.  Its value was set to {1}", new Object[]{paramName, s});
        throw new UnacceptableValueException(msg);
    }

    static Properties convertStringToProperties(String propsString, char sep) {
        Properties properties = new Properties();
        if (propsString != null) {
            ParamTokenizer stoken = new ParamTokenizer(propsString, sep);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextTokenKeepEscapes();
                ParamTokenizer nameTok = new ParamTokenizer(token, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException(adminStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax.", new Object[]{propsString}));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    static Properties convertListToProperties(List<String> propsList) {
        Properties properties = new Properties();
        if (propsList != null) {
            for (String prop : propsList) {
                ParamTokenizer nameTok = new ParamTokenizer(prop, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException(adminStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax.", new Object[]{prop}));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    static List<String> convertStringToList(String listString, char sep) {
        ArrayList<String> list = new ArrayList<String>();
        if (listString != null) {
            ParamTokenizer ptoken = new ParamTokenizer(listString, sep);
            while (ptoken.hasMoreTokens()) {
                String token = ptoken.nextToken();
                list.add(token);
            }
        }
        return list;
    }

    static String[] convertStringToStringArray(String arrayString, char sep) {
        ParamTokenizer paramTok = new ParamTokenizer(arrayString, sep);
        ArrayList<String> strs = new ArrayList<String>();
        while (paramTok.hasMoreTokens()) {
            strs.add(paramTok.nextToken());
        }
        return strs.toArray(new String[strs.size()]);
    }

    static boolean skipValidation(AdminCommand command) {
        try {
            Field f = command.getClass().getDeclaredField("skipParamValidation");
            f.setAccessible(true);
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    private static String encodeManPage(InputStream in) {
        try {
            String line;
            if (in == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static CommandModel getModel(AdminCommand command) {
        if (command instanceof CommandModelProvider) {
            return ((CommandModelProvider)((Object)command)).getModel();
        }
        return new CommandModelImpl(command.getClass());
    }

    private void doCommand(ExecutionContext inv, AdminCommand command) {
        if (command == null && (command = this.getCommand(inv.name(), inv.report(), this.logger)) == null) {
            return;
        }
        CommandModelImpl model = new CommandModelImpl(command.getClass());
        if (inv.typedParams() != null) {
            DelegatedInjectionResolver injectionTarget = new DelegatedInjectionResolver((CommandModel)model, inv.typedParams());
            this.doCommand((CommandModel)model, command, injectionTarget, inv.report(), inv.inboundPayload(), inv.outboundPayload());
            return;
        }
        ParameterMap parameters = inv.parameters();
        if (parameters == null) {
            parameters = new ParameterMap();
        }
        ActionReport report = inv.report();
        if (CommandRunnerImpl.isSet(parameters, "help") || CommandRunnerImpl.isSet(parameters, "Xhelp")) {
            InputStream in = this.getManPage(model.getCommandName(), command);
            String manPage = CommandRunnerImpl.encodeManPage(in);
            if (manPage != null && CommandRunnerImpl.isSet(parameters, "help")) {
                inv.report().getTopMessagePart().addProperty("MANPAGE", manPage);
            } else {
                report.getTopMessagePart().addProperty("GeneratedHelp", "true");
                this.getHelp(command, report);
            }
            return;
        }
        try {
            if (!CommandRunnerImpl.skipValidation(command)) {
                CommandRunnerImpl.validateParameters((CommandModel)model, parameters);
            }
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof UnacceptableValueException) {
                exception = (Exception)cause;
            }
            this.logger.severe(exception.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(CommandRunnerImpl.getUsageText(command, (CommandModel)model));
            return;
        }
        MapInjectionResolver injectionMgr = new MapInjectionResolver((CommandModel)model, parameters);
        this.doCommand((CommandModel)model, command, injectionMgr, report, inv.inboundPayload(), inv.outboundPayload());
    }

    private static boolean isSet(ParameterMap params, String name) {
        String val = (String)params.getOne(name);
        if (val == null) {
            return false;
        }
        return val.length() == 0 || Boolean.valueOf(val) != false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapInjectionResolver
    extends InjectionResolver<Param> {
        private final CommandModel model;
        private final ParameterMap parameters;

        public MapInjectionResolver(CommandModel model, ParameterMap parameters) {
            super(Param.class);
            this.model = model;
            this.parameters = parameters;
        }

        public boolean isOptional(AnnotatedElement element, Param annotation) {
            String name = this.model.getParamName(annotation, element);
            CommandModel.ParamModel param = this.model.getModelFor(name);
            return param.getParam().optional();
        }

        public Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
            List value;
            Param param = target.getAnnotation(Param.class);
            String paramName = CommandRunnerImpl.getParamName(param, target);
            if (param.primary() && (value = this.parameters.get("DEFAULT")) != null && value.size() > 0) {
                this.parameters.set(paramName, value);
                return CommandRunnerImpl.convertListToObject(target, type, value);
            }
            String paramValueStr = CommandRunnerImpl.getParamValueString(this.parameters, param, target);
            CommandRunnerImpl.checkAgainstAcceptableValues(target, paramValueStr);
            if (paramValueStr != null) {
                return CommandRunnerImpl.convertStringToObject(target, type, paramValueStr);
            }
            return CommandRunnerImpl.getParamField(component, target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatedInjectionResolver
    extends InjectionResolver<Param> {
        private final CommandModel model;
        private final CommandParameters parameters;

        public DelegatedInjectionResolver(CommandModel model, CommandParameters parameters) {
            super(Param.class);
            this.model = model;
            this.parameters = parameters;
        }

        public boolean isOptional(AnnotatedElement element, Param annotation) {
            String name = this.model.getParamName(annotation, element);
            CommandModel.ParamModel param = this.model.getModelFor(name);
            return param.getParam().optional();
        }

        public Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
            if (target instanceof Field) {
                Field targetField = (Field)target;
                try {
                    Field sourceField = this.parameters.getClass().getField(targetField.getName());
                    targetField.setAccessible(true);
                    Object paramValue = sourceField.get(this.parameters);
                    if (paramValue != null) {
                        CommandRunnerImpl.checkAgainstAcceptableValues(target, paramValue.toString());
                    }
                    return paramValue;
                }
                catch (IllegalAccessException e) {
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private class ExecutionContext
    implements CommandRunner.CommandInvocation {
        protected final String name;
        protected final ActionReport report;
        protected ParameterMap params;
        protected CommandParameters paramObject;
        protected Payload.Inbound inbound;
        protected Payload.Outbound outbound;

        private ExecutionContext(String name, ActionReport report) {
            this.name = name;
            this.report = report;
        }

        public CommandRunner.CommandInvocation parameters(CommandParameters paramObject) {
            this.paramObject = paramObject;
            return this;
        }

        public CommandRunner.CommandInvocation parameters(ParameterMap params) {
            this.params = params;
            return this;
        }

        public CommandRunner.CommandInvocation inbound(Payload.Inbound inbound) {
            this.inbound = inbound;
            return this;
        }

        public CommandRunner.CommandInvocation outbound(Payload.Outbound outbound) {
            this.outbound = outbound;
            return this;
        }

        public void execute() {
            this.execute(null);
        }

        private ParameterMap parameters() {
            return this.params;
        }

        private CommandParameters typedParams() {
            return this.paramObject;
        }

        private String name() {
            return this.name;
        }

        private ActionReport report() {
            return this.report;
        }

        private Payload.Inbound inboundPayload() {
            return this.inbound;
        }

        private Payload.Outbound outboundPayload() {
            return this.outbound;
        }

        public void execute(AdminCommand command) {
            CommandRunnerImpl.this.doCommand(this, command);
        }
    }
}

