/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.NoSuchElementException;

public class ParamTokenizer {
    protected int currentPosition = 0;
    protected int maxPosition;
    protected String str;
    protected char delimiter;
    protected StringBuilder token = new StringBuilder();
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ParamTokenizer.class);

    public ParamTokenizer(String str, char delimiter) {
        this.str = str;
        this.delimiter = delimiter;
        this.maxPosition = str.length();
    }

    public boolean hasMoreTokens() {
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() throws NoSuchElementException {
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException(localStrings.getLocalString("NoMoreTokens", "No more tokens"));
        }
        return this.scanToken(false);
    }

    public String nextTokenKeepEscapes() throws NoSuchElementException {
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException(localStrings.getLocalString("NoMoreTokens", "No more tokens"));
        }
        return this.scanToken(true);
    }

    protected String scanToken(boolean keep) throws IllegalArgumentException {
        while (this.currentPosition < this.maxPosition) {
            char c;
            if ((c = this.str.charAt(this.currentPosition++)) == '\"' || c == '\'') {
                if (keep) {
                    this.token.append(c);
                }
                char quote = c;
                while (this.currentPosition < this.maxPosition) {
                    if ((c = this.str.charAt(this.currentPosition++)) == '\\' && quote == '\"') {
                        if (this.currentPosition >= this.maxPosition) {
                            throw new IllegalArgumentException(localStrings.getLocalString("EscapeAtEOL", "Escape at EOL"));
                        }
                        c = this.str.charAt(this.currentPosition++);
                        if (keep) {
                            this.token.append('\\');
                        }
                    } else if (c == quote) break;
                    this.token.append(c);
                }
                if (c != quote) {
                    throw new IllegalArgumentException(localStrings.getLocalString("UnbalancedQuotes", "Unbalanced quotes"));
                }
                if (!keep) continue;
                this.token.append(c);
                continue;
            }
            if (c == this.delimiter) break;
            if (c == '\\') {
                if (this.currentPosition >= this.maxPosition) {
                    throw new IllegalArgumentException(localStrings.getLocalString("EscapeAtEOL", "Escape at EOL"));
                }
                c = this.str.charAt(this.currentPosition++);
                if (keep) {
                    this.token.append('\\');
                }
                this.token.append(c);
                continue;
            }
            this.token.append(c);
        }
        String s = this.token.toString();
        this.token.setLength(0);
        return s;
    }
}

