/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="json")
@Scoped(value=PerLookup.class)
public class JsonActionReporter
extends ActionReporter {
    private boolean top = true;

    public void writeReport(OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(os);
        this.write(this.topMessage, writer);
        if (this.exception != null) {
            writer.println("Exception raised during operation : <br>");
            this.exception.printStackTrace(writer);
        }
        if (this.subActions.size() > 0) {
            writer.println(this.quote(", number_subactions") + ":" + this.quote("" + this.subActions.size()));
        }
        writer.flush();
    }

    private void write(ActionReport.MessagePart part, PrintWriter writer) {
        writer.println("{ " + this.quote("name") + ":" + this.quote(part.getMessage()));
        if (this.top) {
            writer.println(", " + this.quote("command") + ":" + this.quote(this.actionDescription));
            writer.println(", " + this.quote("exit_code") + ":" + this.quote("" + (Object)((Object)this.exitCode)));
            this.top = false;
        }
        this.writeProperties(part.getProps(), writer);
        boolean first = true;
        for (ActionReport.MessagePart child : part.getChildren()) {
            if (first) {
                writer.println(", " + this.quote("result") + " : [");
            } else {
                writer.println(",");
            }
            first = false;
            this.write(child, writer);
        }
        if (!first) {
            writer.println("]");
        }
        writer.println("}");
    }

    private void writeProperties(Properties props, PrintWriter writer) {
        if (props == null || props.size() == 0) {
            return;
        }
        writer.println("," + this.quote("properties") + " : ");
        boolean needComma = false;
        writer.println("{");
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (needComma) {
                writer.println(",");
            }
            needComma = true;
            writer.println(this.quote("" + entry.getKey()) + " : " + this.quote("" + entry.getValue()));
        }
        writer.println("}");
    }

    private String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

