/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Cluster
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getConfigRef();

    @Param(name="config", optional=true)
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getHeartbeatEnabled();

    public void setHeartbeatEnabled(String var1) throws PropertyVetoException;

    @Attribute
    @Min(value=1024L)
    @Max(value=49151L)
    public String getHeartbeatPort();

    public void setHeartbeatPort(String var1) throws PropertyVetoException;

    @Attribute
    public String getHeartbeatAddress();

    public void setHeartbeatAddress(String var1) throws PropertyVetoException;

    @Element
    public List<ServerRef> getServerRef();

    @Override
    @Element
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system props")
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @DuckTyped
    public String getReference();

    @DuckTyped
    public List<Server> getInstances();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Cluster> {
        @Param(name="config", optional=true)
        String configRef = null;
        @Param(optional=true)
        String hosts = null;
        @Param(optional=true)
        int haagentport = 0;
        @Param(optional=true)
        String haadminpassword = null;
        @Param(optional=true)
        String haadminpasswordfile = null;
        @Param(optional=true)
        String devicesize = null;
        @Param(optional=true)
        String haproperty = null;
        @Param(optional=true)
        String autohadb = null;
        @Param(optional=true)
        String portbase = null;
        @Inject
        Habitat habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;

        @Override
        public void decorate(AdminCommandContext context, Cluster instance) throws TransactionFailure, PropertyVetoException {
            Logger logger = LogDomains.getLogger(Cluster.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            if (this.domain.getServerNamed(instance.getName()) != null || this.domain.getConfigNamed(instance.getName()) != null) {
                throw new TransactionFailure(localStrings.getLocalString("cannotAddDuplicate", "There is an instance {0} already present.", new Object[]{instance.getName()}));
            }
            if (this.configRef == null) {
                Config configCopy;
                Config config = (Config)this.habitat.getComponent(Config.class, "default-config");
                if (config == null) {
                    config = (Config)this.habitat.getAllByContract(Config.class).iterator().next();
                    logger.warning(localStrings.getLocalString(Cluster.class, "Cluster.no_default_config_found", "No default config found, using config {0} as the default config for the cluster {1}", new Object[]{config.getName(), instance.getName()}));
                }
                try {
                    configCopy = (Config)config.deepCopy();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, localStrings.getLocalString(Cluster.class, "Cluster.error_while_copying", "Error while copying the default configuration {0)", new Object[]{e.toString(), e}));
                    throw new TransactionFailure(e.toString(), (Throwable)e);
                }
                final String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy[] w) throws PropertyVetoException, TransactionFailure {
                        ((Configs)w[0]).getConfig().add(configCopy);
                        ((Config)w[1]).setName(configName);
                        return null;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.domain.getConfigs(), configCopy});
            } else {
                Config specifiedConfig = this.domain.getConfigs().getConfigByName(this.configRef);
                if (specifiedConfig == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", new Object[]{this.configRef}));
                }
            }
            for (Resource resource : this.domain.getResources().getResources()) {
                if (!resource.getObjectType().equals("system-all")) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)resource).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = (ResourceRef)instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all")) continue;
                ApplicationRef newAppRef = (ApplicationRef)instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
            if (this.hosts != null || this.haagentport != 0 || this.haadminpassword != null || this.haadminpasswordfile != null || this.devicesize != null || this.haproperty != null || this.autohadb != null || this.portbase != null) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.WARNING);
                context.getActionReport().setMessage("Obsolete options used.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static String getReference(Cluster cluster) {
            return cluster.getConfigRef();
        }

        public static List<Server> getInstances(Cluster cluster) {
            Dom clusterDom = Dom.unwrap((ConfigBeanProxy)cluster);
            Domain domain = (Domain)clusterDom.getHabitat().getComponent(Domain.class);
            ArrayList<Server> instances = new ArrayList<Server>();
            for (ServerRef sRef : cluster.getServerRef()) {
                instances.add(domain.getServerNamed(sRef.getRef()));
            }
            return instances;
        }
    }
}

