/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.config.ContextRootInfo;
import com.sun.grizzly.config.FileCacheAware;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticHandler;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

public class ContainerStaticHandler
extends StaticHandler {
    private static Method getServletClassMethod = null;
    protected static final int MAPPING_DATA = 12;

    public int handle(Request req, int handlerCode) throws IOException {
        if (this.fileCache == null || !this.fileCache.isEnabled()) {
            return 0;
        }
        MappingData mappingData = (MappingData)req.getNote(12);
        if (handlerCode == 1 && mappingData != null) {
            boolean isWebContainer = mappingData.wrapper != null && mappingData.wrapper.getClass().getName().equals("org.apache.catalina.core.StandardWrapper");
            ContextRootInfo cri = null;
            if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
                cri = (ContextRootInfo)mappingData.context;
            }
            if (isWebContainer) {
                try {
                    Object wrapper = mappingData.wrapper;
                    String servletClass = (String)ContainerStaticHandler.getServletClassMethod(wrapper).invoke(wrapper, new Object[0]);
                    if (!"org.apache.catalina.servlets.DefaultServlet".equals(servletClass)) {
                        return 0;
                    }
                    String docroot = System.getProperty("com.sun.aas.instanceRoot") + File.separatorChar + "applications";
                    String uri = req.requestURI().toString();
                    this.fileCache.add("default", docroot, uri, req.getResponse().getMimeHeaders(), false);
                }
                catch (Exception ex) {
                    IOException ioex = new IOException();
                    ioex.initCause(ex);
                    throw ioex;
                }
            } else if (cri != null && cri.getAdapter() instanceof FileCacheAware) {
                req.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, (Object)req);
                String docroot = SelectorThread.getSelector((int)req.getLocalPort()).getWebAppRootPath();
                String uri = req.requestURI().toString();
                this.fileCache.add("default", docroot, uri, req.getResponse().getMimeHeaders(), false);
            }
        }
        if (handlerCode == 0) {
            ByteChunk requestURI = req.requestURI().getByteChunk();
            if (this.fileCache.sendCache(req)) {
                return 1;
            }
        }
        return 0;
    }

    private static synchronized Method getServletClassMethod(Object wrapper) throws NoSuchMethodException {
        if (getServletClassMethod == null) {
            Class<?> clazz = wrapper.getClass();
            getServletClassMethod = clazz.getMethod("getServletClassName", new Class[0]);
        }
        return getServletClassMethod;
    }
}

