/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-lifecycle-module")
@I18n(value="delete.lifecycle.module")
@Scoped(value=PerLookup.class)
public class DeleteLifecycleModuleCommand
implements AdminCommand {
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Inject
    Deployment deployment;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteLifecycleModuleCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (!this.deployment.isRegistered(this.name)) {
            report.setMessage("Lifecycle module with name [" + this.name + "] does not exist");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.deployment.unregisterAppFromDomainXML(this.name, this.target);
        }
        catch (Exception e) {
            report.setMessage("Failed to delete lifecycle module: " + e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

