/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public class MonitorTask
extends TimerTask {
    private String type = null;
    private String filter = null;
    private Timer timer = null;
    private File fileName = null;
    private String[] remoteArgs;
    private String exceptionMessage = null;
    private RemoteCommand cmd;
    private static final int NUM_ROWS = 25;
    private int counter = 0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MonitorTask.class);

    public MonitorTask(Timer timer, String[] remoteArgs, ProgramOptions programOpts, Environment env, String type, String filter, File fileName) throws CommandException, CommandValidationException {
        this.timer = timer;
        if (type != null && type.length() > 0) {
            this.type = type;
        }
        if (filter != null && filter.length() > 0) {
            this.filter = filter;
        }
        this.fileName = fileName;
        this.remoteArgs = remoteArgs;
        this.cmd = new RemoteCommand(remoteArgs[0], programOpts, env);
        this.displayHeader(type);
    }

    void displayHeader(String type) {
        String title = "";
        if ("servlet".equals(type)) {
            title = String.format("%1$-10s %2$-10s %3$-10s", "aslc", "mslc", "tslc");
        } else if ("httplistener".equals(type)) {
            title = String.format("%1$-4s %2$-4s %3$-6s %4$-4s", "ec", "mt", "pt", "rc");
        } else if ("jvm".equals(type)) {
            title = String.format("%1$45s", "JVM Monitoring");
            CLILogger.getInstance().printMessage(title);
            title = null;
            if (this.filter != null && ("heapmemory".equals(this.filter) || "nonheapmemory".equals(this.filter))) {
                title = String.format("%1$-10s %2$-10s %3$-10s %4$-10s", "init", "used", "committed", "max");
            }
            if (title == null) {
                title = String.format("%1$-35s %2$-40s", "UpTime(ms)", "Heap and NonHeap Memory(bytes)");
                CLILogger.getInstance().printMessage(title);
                title = String.format("%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s", "current", "min", "max", "low", "high", "count");
            }
        } else if ("webmodule".equals(type)) {
            title = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s", "asc", "ast", "rst", "st", "ajlc", "mjlc", "tjlc", "aslc", "mslc", "tslc");
        }
        CLILogger.getInstance().printMessage(title);
    }

    void cancelMonitorTask() {
        this.timer.cancel();
        try {
            Robot robot = new Robot();
            robot.keyPress(81);
            robot.keyRelease(81);
            robot.keyPress(10);
            robot.keyRelease(10);
        }
        catch (AWTException e) {
            CLILogger.getInstance().printError(strings.get("awt.error", new Object[]{e.getMessage()}));
        }
    }

    public void run() {
        try {
            this.cmd.execute(this.remoteArgs);
            if (this.counter == 25) {
                this.displayHeader(this.type);
                this.counter = 0;
            }
            ++this.counter;
        }
        catch (Exception e) {
            CLILogger.getInstance().printError(strings.get("monitorCommand.errorRemote", new Object[]{e.getMessage()}));
            this.cancelMonitorTask();
            this.exceptionMessage = e.getMessage();
        }
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void displayDetails() {
        CLILogger.getInstance().printMessage("These are the details");
    }
}

