/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASMain {
    static final Logger logger = Logger.getAnonymousLogger();

    public static void main(String[] args) {
        ASMain.checkJdkVersion();
        String platform = ASMain.whichPlatform();
        File installRoot = ASMain.findInstallRoot();
        File instanceRoot = ASMain.findInstanceRoot(installRoot, args);
        Properties ctx = ASMain.buildStartupContext(platform, installRoot, instanceRoot, args);
        ASMain.setSystemProperties(ctx);
        PlatformMain delegate = ASMain.getMain(platform);
        if (delegate != null) {
            logger.info("Launching GlassFish on " + platform + " platform");
            logger.fine("Startup Context: " + ctx);
            try {
                delegate.setLogger(logger);
                delegate.start(ctx);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            logger.severe("Cannot launch GlassFish on the unknown " + platform + " platform");
        }
    }

    private static void checkJdkVersion() {
        int minor = ASMain.getMinorJdkVersion();
        if (minor < 6) {
            logger.severe("GlassFish requires JDK 6, you are using JDK version " + minor);
            System.exit(1);
        }
    }

    private static File findInstallRoot() {
        File bootstrapFile = ASMain.findBootstrapFile();
        return bootstrapFile.getParentFile().getParentFile();
    }

    private static File findInstanceRoot(File installRoot, String[] args) {
        ASMainHelper helper = new ASMainHelper(logger);
        Properties asEnv = helper.parseAsEnv(installRoot);
        File instanceDir = helper.getInstanceRoot(ArgumentManager.argsToMap((String[])args), asEnv);
        if (instanceDir == null) {
            instanceDir = helper.getDomainRoot(ArgumentManager.argsToMap((String[])args), asEnv);
        }
        helper.verifyDomainRoot(instanceDir);
        return instanceDir;
    }

    private static String whichPlatform() {
        String platform = Constants.Platform.Felix.toString();
        String temp = System.getProperty("GlassFish_Platform");
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv("GlassFish_Platform");
        }
        if (temp != null && temp.trim().length() != 0) {
            platform = temp.trim();
        }
        return platform;
    }

    private static PlatformMain getMain(String platform) {
        ServiceLoader<PlatformMain> loader = ServiceLoader.load(PlatformMain.class, ASMain.class.getClassLoader());
        for (PlatformMain main : loader) {
            if (!main.getName().equalsIgnoreCase(platform)) continue;
            return main;
        }
        return null;
    }

    private static Properties buildStartupContext(String platform, File installRoot, File instanceRoot, String[] args) {
        Properties p = ArgumentManager.argsToMap((String[])args);
        p.put("__time_zero", new Long(System.currentTimeMillis()).toString());
        p.setProperty("GlassFish_Platform", platform);
        p.put("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        p.put("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        if (p.getProperty("hk2.startup.context.mainModule") == null) {
            p.put("hk2.startup.context.mainModule", "org.glassfish.core.kernel");
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-upgrade") || i + 1 >= args.length || args[i + 1].equals("false")) continue;
            p.put("hk2.startup.context.moduleStartup", "upgrade");
        }
        ASMain.addRawStartupInfo(args, p);
        return p;
    }

    private static void setSystemProperties(Properties ctx) {
        System.setProperty("GlassFish_Platform", ctx.getProperty("GlassFish_Platform"));
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",,,");
            }
            sb.append(args[i]);
        }
        if (!ASMain.wasStartedByCLI(p)) {
            p.put("-startup-classpath", System.getProperty("java.class.path"));
            p.put("-startup-classname", ASMain.class.getName());
            p.put("-startup-args", sb.toString());
        }
    }

    private static boolean wasStartedByCLI(Properties props) {
        return props.getProperty("-asadmin-classpath") != null && props.getProperty("-asadmin-classname") != null && props.getProperty("-asadmin-args") != null;
    }

    private static int getMinorJdkVersion() {
        try {
            String jv = System.getProperty("java.version");
            String[] ss = jv.split("\\.");
            if (ss == null || ss.length < 3 || !ss[0].equals("1")) {
                return 1;
            }
            return Integer.parseInt(ss[1]);
        }
        catch (Exception e) {
            return 1;
        }
    }

    private static File findBootstrapFile() {
        try {
            return Which.jarFile(ASMain.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get bootstrap path from " + ASMain.class + " class location, aborting");
        }
    }
}

