/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.Constants;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.HandShake;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ServerHandShake
extends HandShake {
    private static final byte[] normalResponse = Charset.forName("ASCII").encode("HTTP/1.1 101 Web Socket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nWebSocket-Origin: ").array();
    private static final byte[] locationResponse = Charset.forName("ASCII").encode("\r\nWebSocket-Location: ").array();
    private static final byte[] protocolResponse = Charset.forName("ASCII").encode("\r\nWebSocket-Protocol: ").array();

    public ServerHandShake(MimeHeaders headers, ClientHandShake client) {
        super(client.isSecure(), client.getOrigin(), client.getServerHostName(), client.getResourcePath());
        this.port = client.getPort();
    }

    public ByteBuffer generate() {
        try {
            ByteArrayOutputStream bb = new ByteArrayOutputStream();
            bb.write(normalResponse);
            bb.write(this.getOrigin().getBytes("ASCII"));
            bb.write(locationResponse);
            bb.write(this.getLocation().getBytes("ASCII"));
            String protocol = this.getProtocol();
            if (protocol != null) {
                bb.write(protocolResponse);
                bb.write(protocol.getBytes("ASCII"));
            }
            bb.write(Constants.CRLF_BYTES);
            bb.write(Constants.CRLF_BYTES);
            ByteBuffer buffer = ByteBuffer.allocate(bb.size());
            buffer.put(bb.toByteArray());
            buffer.flip();
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void prepare(Response response) {
        response.setStatus(101);
        response.setMessage("Web Socket Protocol Handshake");
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader("Connection", "Upgrade");
        response.setHeader("WebSocket-Origin", this.getOrigin());
        response.setHeader("WebSocket-Location", this.getLocation());
        if (this.getProtocol() != null) {
            response.setHeader("WebSocket-Protocol", this.getProtocol());
        }
        response.suspend();
    }
}

