/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.logging.Level;

public class WebSocketClient
extends BaseWebSocket
implements WebSocket {
    private SocketChannel channel;
    private static final String CLIENT_HANDSHAKE = "GET /echo HTTP/1.1\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nHost: localhost\r\nOrigin: http://localhost\r\n\r\n";

    public WebSocketClient(String address) throws IOException {
        URL url = new URL(address);
        this.setSelector(SelectorProvider.provider().openSelector());
        new Thread(new Runnable(){

            public void run() {
                WebSocketClient.this.select();
            }
        }).start();
        this.open(url);
    }

    private void open(URL url) throws IOException {
        SocketChannel socketChannel;
        this.channel = socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(url.getHost(), url.getPort()));
        socketChannel.socket().setSoTimeout(30000);
        this.state = BaseWebSocket.State.CONNECTING;
        this.getSelector().wakeup();
    }

    public void close() throws IOException {
        super.close();
        this.channel.close();
    }

    private void select() {
        while (this.state != BaseWebSocket.State.CLOSED) {
            try {
                if (this.state == BaseWebSocket.State.CONNECTING) {
                    this.channel.register(this.getSelector(), 8);
                }
                this.getSelector().select();
                Iterator<SelectionKey> selectedKeys = this.getSelector().selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    this.process(key);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            this.getSelector().wakeup();
        }
    }

    protected void process(SelectionKey key) throws IOException {
        if (key.isValid()) {
            if (key.isConnectable()) {
                this.disableOp(8);
                this.doConnect();
            } else if (key.isReadable()) {
                this.doRead();
            }
            this.enableOp(1);
            key.selector().wakeup();
        }
    }

    protected void doConnect() throws IOException {
        this.channel.finishConnect();
        byte[] bytes = CLIENT_HANDSHAKE.getBytes();
        this.write(bytes);
        this.state = BaseWebSocket.State.WAITING_ON_HANDSHAKE;
        super.doConnect();
    }

    protected void doRead() throws IOException {
        switch (this.state) {
            case WAITING_ON_HANDSHAKE: {
                ByteBuffer buffer = ByteBuffer.allocate(8192);
                int read = this.channel.read(buffer);
                this.state = BaseWebSocket.State.READY;
                this.setConnected(true);
                break;
            }
            case READY: {
                super.doRead();
                break;
            }
        }
    }

    protected void unframe() throws IOException {
        int count;
        do {
            ByteBuffer bytes = ByteBuffer.allocate(8192);
            count = this.channel.read(bytes);
            bytes.flip();
            this.unframe(bytes);
        } while (count > 0);
    }

    protected void write(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        int i = this.channel.write(buffer);
    }

    protected SelectionKey getKey() {
        return this.channel.keyFor(this.getSelector());
    }

    void enableOp(int op) {
        SelectionKey key = this.getKey();
        int ops = key.interestOps();
        int newOp = ops | op;
        if (newOp != ops) {
            key.interestOps(newOp);
        }
        key.selector().wakeup();
    }

    void disableOp(int op) {
        SelectionKey key = this.getKey();
        int ops = key.interestOps();
        int newOp = ops & ~op;
        if (newOp != ops) {
            key.interestOps(newOp);
        }
    }
}

