/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.util.PortUtils;
import com.sun.enterprise.config.util.ServerPorts;
import com.sun.enterprise.config.util.Strings;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jvnet.hk2.config.TransactionFailure;

public final class PortManager {
    private final String serverName;
    private final Server newServer;
    private final String dasName;
    private final boolean isLocal;
    private final Domain domain;
    private final String host;
    private final List<Server> allServers;
    private final List<ServerPorts> serversOnHost;

    public PortManager(Server theDas, Domain theDomain, Server theNewServer) throws TransactionFailure {
        try {
            if (theNewServer == null || theDomain == null) {
                throw new TransactionFailure(Strings.get("internal.error", "null argument in PortManager constructor"));
            }
            this.dasName = theDas.getName();
            if (!StringUtils.ok((String)this.dasName)) {
                throw new TransactionFailure(Strings.get("internal.error", "null or empty DAS name."));
            }
            this.newServer = theNewServer;
            this.domain = theDomain;
            this.serverName = this.newServer.getName();
            this.host = this.newServer.getNodeAgentRef();
            if (!StringUtils.ok((String)this.host)) {
                throw new TransactionFailure(Strings.get("PortManager.noHost", this.serverName));
            }
            this.isLocal = NetUtils.IsThisHostLocal((String)this.host);
            this.allServers = this.domain.getServers().getServer();
            Iterator<Server> it = this.allServers.iterator();
            while (it.hasNext()) {
                Server curr = it.next();
                if (!this.serverName.equals(curr.getName())) continue;
                it.remove();
            }
            this.serversOnHost = new ArrayList<ServerPorts>();
        }
        catch (TransactionFailure tf) {
            throw tf;
        }
        catch (Exception e) {
            throw new TransactionFailure(e.toString(), (Throwable)e);
        }
    }

    public void justDoIt() throws TransactionFailure {
        try {
            PortUtils.checkInternalConsistency(this.newServer);
            this.createServerList();
        }
        catch (TransactionFailure tf) {
            throw tf;
        }
        catch (Exception e) {
            throw new TransactionFailure(e.toString(), (Throwable)e);
        }
    }

    private void createServerList() {
        if (this.isLocal) {
            this.createLocalServerList();
        } else {
            this.createRemoteServerList();
        }
    }

    private void createLocalServerList() {
        for (Server server : this.allServers) {
            if (server.isDas()) {
                this.serversOnHost.add(new ServerPorts(this.domain, server));
                continue;
            }
            if (!NetUtils.IsThisHostLocal((String)server.getNodeAgentRef())) continue;
            this.serversOnHost.add(new ServerPorts(this.domain, server));
        }
    }

    private void createRemoteServerList() {
        for (Server server : this.allServers) {
            if (!server.isInstance() || !this.sameHost(server)) continue;
            this.serversOnHost.add(new ServerPorts(this.domain, server));
        }
    }

    private boolean sameHost(Server server) {
        return NetUtils.isEqual((String)server.getNodeAgentRef(), (String)this.host);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PortManager Dump:");
        for (ServerPorts sp : this.serversOnHost) {
            sb.append(sp).append('\n');
        }
        return sb.toString();
    }
}

