/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.NanoDuration;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.DasReaderFilter;
import org.glassfish.config.support.InstanceReaderFilter;
import org.glassfish.config.support.ServerReaderFilter;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public abstract class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    protected Habitat habitat;
    @Inject
    ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainXml.class);

    public void run(ConfigParser parser) {
        EarlyLogger.add((Level)Level.FINE, (String)("Startup class : " + this.getClass().getName()));
        this.habitat.addComponent("parent-class-loader", (Object)new ExistingSingletonInhabitant(ClassLoader.class, (Object)this.registry.getParentClassLoader()));
        try {
            this.parseDomainXml(parser, this.getDomainXml(this.env), this.env.getInstanceName());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse domain.xml", e);
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        this.decorate();
    }

    protected void decorate() {
        Server server = (Server)this.habitat.getComponent(Server.class, this.env.getInstanceName());
        this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant((Object)server), Server.class.getName(), "default-instance-name");
        this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant(this.habitat.getComponent(Config.class, server.getConfigRef())), Config.class.getName(), "default-instance-name");
    }

    protected void upgrade() {
        for (Inhabitant cu : this.habitat.getInhabitants(ConfigurationUpgrade.class)) {
            try {
                cu.get();
                EarlyLogger.add((Level)Level.FINE, (String)("Successful Upgrade domain.xml with " + cu.getClass()));
            }
            catch (Exception e) {
                EarlyLogger.add((Level)Level.FINE, (String)(e.toString() + e));
                EarlyLogger.add((Level)Level.SEVERE, (String)(cu.getClass() + " upgrading domain.xml failed " + e));
            }
        }
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        return new File(env.getConfigDirPath(), "domain.xml").toURI().toURL();
    }

    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        long startNano = System.nanoTime();
        try {
            ServerReaderFilter xsr = null;
            if (this.env.getRuntimeType() == RuntimeType.DAS || this.env.getRuntimeType() == RuntimeType.EMBEDDED) {
                xsr = new DasReaderFilter(this.habitat, domainXml, this.xif);
            } else if (this.env.getRuntimeType() == RuntimeType.INSTANCE) {
                xsr = new InstanceReaderFilter(this.env.getInstanceName(), this.habitat, domainXml, this.xif);
            } else {
                throw new RuntimeException("Internal Error: Unknown server type: " + this.env.getRuntimeType());
            }
            parser.parse((XMLStreamReader)xsr, this.getDomDocument());
            xsr.close();
            String errorMessage = ((ServerReaderFilter)xsr).configWasFound();
            if (errorMessage != null) {
                EarlyLogger.add((Level)Level.WARNING, (String)errorMessage);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Fatal Error.  Unable to parse " + domainXml, e);
        }
        EarlyLogger.add((Level)Level.INFO, (String)strings.get("time", new Object[]{new NanoDuration(System.nanoTime() - startNano).toString()}));
    }

    protected abstract DomDocument getDomDocument();
}

