/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMapExtractor {
    private final AdminCommand command;

    public ParameterMapExtractor(AdminCommand command) {
        this.command = command;
    }

    public ParameterMap extract() throws IllegalArgumentException, IllegalAccessException {
        return this.extract(Collections.EMPTY_SET);
    }

    public ParameterMap extract(Collection<String> parameterNamesToExclude) throws IllegalArgumentException, IllegalAccessException {
        ParameterMap paramMap = new ParameterMap();
        for (Field f : this.command.getClass().getFields()) {
            Object fieldValue;
            Param param = f.getAnnotation(Param.class);
            if (param == null || parameterNamesToExclude.contains(f.getName()) || (fieldValue = f.get(this.command)) == null) continue;
            String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)f);
            if (param.multiple()) {
                paramMap.set((Object)paramName, this.multipleValue(param, f.get(this.command)));
                continue;
            }
            paramMap.set((Object)paramName, (Object)this.singleValue(param, f.get(this.command)));
        }
        return paramMap;
    }

    private String singleValue(Param p, Object value) {
        if (value.getClass().isAssignableFrom(String.class)) {
            return (String)value;
        }
        if (value.getClass().isAssignableFrom(File.class)) {
            return ((File)value).getAbsolutePath();
        }
        if (value.getClass().isAssignableFrom(Properties.class)) {
            return this.propertiesValue((Properties)value, p.separator());
        }
        if (value.getClass().isAssignableFrom(List.class)) {
            return this.listValue((List)value, p.separator());
        }
        if (value.getClass().isAssignableFrom(Boolean.class)) {
            return ((Boolean)value).toString();
        }
        if (value.getClass().isAssignableFrom(String[].class)) {
            return this.stringListValue((String[])value, p.separator());
        }
        return value.toString();
    }

    private String listValue(List list, char sep) {
        StringBuilder sb = new StringBuilder();
        String currentSep = "";
        for (Object o : list) {
            sb.append(currentSep).append(o.toString());
            currentSep = String.valueOf(sep);
        }
        return sb.toString();
    }

    private String stringListValue(String[] value, char sep) {
        StringBuilder sb = new StringBuilder();
        String currentSep = "";
        for (String s : value) {
            sb.append(currentSep).append(s);
            currentSep = String.valueOf(sep);
        }
        return sb.toString();
    }

    public String propertiesValue(Properties props, char sep) {
        StringBuilder sb = new StringBuilder();
        String currentSep = "";
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object v = props.get(key);
            sb.append(currentSep).append(key.toString()).append("=").append(v.toString());
            currentSep = String.valueOf(sep);
        }
        return sb.toString();
    }

    private Collection<? extends String> multipleValue(Param p, Object value) {
        ArrayList<String> result = new ArrayList<String>();
        List multiValue = (List)value;
        for (Object o : multiValue) {
            result.add(this.singleValue(p, o));
        }
        return result;
    }
}

