/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="redeploy")
@Scoped(value=PerLookup.class)
@I18n(value="redeploy.command")
@Cluster(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class ReDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Param(optional=false)
    String name;
    @Param(primary=true, optional=true)
    File path = null;
    boolean skipParamValidation = true;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ReDeployCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.validateParameters(this.name, report)) {
            return;
        }
        this.force = true;
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("deploy", report);
        inv.parameters((CommandParameters)this).inbound(context.getInboundPayload()).outbound(context.getOutboundPayload()).execute();
    }

    boolean validateParameters(String name, ActionReport report) {
        if (!this.deployment.isRegistered(name)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.path == null && !Boolean.parseBoolean(ConfigBeansUtilities.getDirectoryDeployed((String)name))) {
            report.setMessage(localStrings.getLocalString("redeploy.command.cannot.redeploy", "Cannot redeploy this app {0} without specify the operand.", new Object[]{name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        File file = ((DeployCommandParameters)this).path = this.path == null ? new File(ConfigBeansUtilities.getLocation((String)name)) : this.path;
        if (((DeployCommandParameters)this).path == null) {
            report.setMessage(localStrings.getLocalString("redeploy.command.invalid.path", "Cannot determine the path of application."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

