/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
public interface Node
extends ConfigBeanProxy,
Injectable,
Named,
ReferenceContainer,
RefContainer {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    public String getNodeHost();

    @Param(name="nodehost")
    public void setNodeHost(String var1) throws PropertyVetoException;

    @Attribute
    public String getNodeHome();

    @Param(name="nodehome")
    public void setNodeHome(String var1) throws PropertyVetoException;

    @Element
    public SshConnector getSshConnector();

    public void setSshConnector(SshConnector var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<Nodes, Node> {
        @Inject
        private Domain domain;
        @Inject
        Nodes nodes;
        @Inject
        Servers servers;
        @Inject
        private ServerEnvironment env;

        @Override
        public void decorate(AdminCommandContext context, Nodes parent, Node child) throws PropertyVetoException, TransactionFailure {
            Logger logger = LogDomains.getLogger(Node.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Node.class);
            ActionReport report = context.getActionReport();
            String nodeName = child.getName();
            if (nodeName.equals("localhost")) {
                String msg = localStrings.getLocalString("Node.localhost", "Cannot remove Node {0}. ", new Object[]{child.getName()});
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            List<Node> nodeList = this.nodes.getNode();
            List<Server> serverList = this.servers.getServer();
            if (serverList.size() > 0) {
                for (Server server : serverList) {
                    if (!nodeName.equals(server.getNode())) continue;
                    String msg = localStrings.getLocalString("Node.referencedByInstance", "Node {0} referenced in server instance {1}.  Remove instance before removing node.", new Object[]{child.getName(), server.getName()});
                    logger.log(Level.SEVERE, msg);
                    throw new TransactionFailure(msg);
                }
            }
            nodeList.remove(child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Node> {
        @Param(name="sshport", optional=true)
        String sshPort = "-1";
        @Param(name="sshnodehost", optional=true)
        String sshHost = null;
        @Param(name="sshuser", optional=true)
        String sshuser = null;
        @Param(name="sshkeyfile", optional=true)
        String sshkeyfile;
        @Inject
        Habitat habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;

        @Override
        public void decorate(AdminCommandContext context, Node instance) throws TransactionFailure, PropertyVetoException {
            Logger logger = LogDomains.getLogger(Node.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Node.class);
            SshConnector sshC = (SshConnector)instance.createChild(SshConnector.class);
            if (this.sshPort != "-1") {
                sshC.setSshPort(this.sshPort);
            } else {
                sshC.setSshPort("22");
            }
            if (this.sshHost != null) {
                sshC.setSshHost(this.sshHost);
            }
            if (this.sshuser != null || this.sshkeyfile != null) {
                SshAuth sshA = (SshAuth)sshC.createChild(SshAuth.class);
                if (this.sshuser != null) {
                    sshA.setUserName(this.sshuser);
                }
                if (this.sshkeyfile != null) {
                    sshA.setKeyfile(this.sshkeyfile);
                }
                sshC.setSshAuth(sshA);
            }
            instance.setSshConnector(sshC);
        }
    }
}

