/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.util.PortManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Server
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    public String getConfigRef();

    @Param(name="config", optional=true)
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute
    public String getNodeAgentRef();

    @Param(name="nodeagent", optional=true)
    public void setNodeAgentRef(String var1) throws PropertyVetoException;

    @Param(name="node", optional=true)
    public void setNode(String var1) throws PropertyVetoException;

    @Attribute
    public String getNode();

    @Attribute(defaultValue="100")
    @Min(value=1L)
    public String getLbWeight();

    public void setLbWeight(String var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system properties")
    @Element
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @DuckTyped
    public String getReference();

    @DuckTyped
    public ResourceRef getResourceRef(String var1);

    @DuckTyped
    public boolean isResourceRefExists(String var1);

    @DuckTyped
    public void deleteResourceRef(String var1) throws TransactionFailure;

    @DuckTyped
    public void createResourceRef(String var1, String var2) throws TransactionFailure;

    @DuckTyped
    public ApplicationRef getApplicationRef(String var1);

    @DuckTyped
    public Cluster getCluster();

    @DuckTyped
    public boolean isCluster();

    @DuckTyped
    public boolean isServer();

    @DuckTyped
    public boolean isDas();

    @DuckTyped
    public boolean isInstance();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<Servers, Server> {
        @Inject
        Configs configs;
        @Inject
        private Domain domain;
        @Inject
        private ServerEnvironment env;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void decorate(AdminCommandContext context, Servers parent, Server child) throws PropertyVetoException, TransactionFailure {
            boolean isStandAlone;
            Logger logger = LogDomains.getLogger(Server.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Server.class);
            ActionReport report = context.getActionReport();
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)parent);
            Cluster cluster = this.domain.getClusterForInstance(child.getName());
            boolean bl = isStandAlone = cluster == null;
            if (isStandAlone) {
                String instanceConfig = child.getConfigRef();
                Config config = this.configs.getConfigByName(instanceConfig);
                if (config != null && this.domain.getReferenceContainersOf(config).size() > 1) {
                    return;
                }
                try {
                    if (config != null) {
                        File configConfigDir = new File(this.env.getConfigDirPath(), config.getName());
                        FileUtils.whack((File)configConfigDir);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (t == null) return;
                    Configs c = (Configs)t.enroll((ConfigBeanProxy)this.configs);
                    List<Config> configList = c.getConfig();
                    configList.remove(config);
                    return;
                }
                catch (TransactionFailure ex) {
                    logger.log(Level.SEVERE, localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", new Object[]{instanceConfig}), ex);
                    String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", new Object[]{instanceConfig});
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause((Throwable)ex);
                    throw ex;
                }
            }
            String instanceName = child.getName();
            if (t == null) return;
            try {
                Cluster c = (Cluster)t.enroll((ConfigBeanProxy)cluster);
                List<ServerRef> serverRefList = c.getServerRef();
                ServerRef serverRef = null;
                for (ServerRef sr : serverRefList) {
                    if (!sr.getRef().equals(instanceName)) continue;
                    serverRef = sr;
                    break;
                }
                if (serverRef == null) return;
                serverRefList.remove(serverRef);
                return;
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, localStrings.getLocalString("deleteServerRefFailed", "Unable to remove server-ref {0} from cluster {1}", new Object[]{instanceName, cluster.getName()}), ex);
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteServerRefFailed", "Unable to remove server-ref {0} from cluster {1}", new Object[]{instanceName, cluster.getName()});
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                throw ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class CreateDecorator
    implements CreationDecorator<Server> {
        @Param(name="cluster", optional=true)
        String clusterName;
        @Param(name="node", optional=true)
        String node = null;
        @Inject
        Domain domain;
        @Inject
        private ServerEnvironment env;

        @Override
        public void decorate(AdminCommandContext context, Server instance) throws TransactionFailure, PropertyVetoException {
            File configConfigDir;
            Config ourConfig = null;
            Cluster ourCluster = null;
            Logger logger = LogDomains.getLogger(Cluster.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Server.class);
            Transaction tx = Transaction.getTransaction((ConfigBeanProxy)instance);
            String configRef = instance.getConfigRef();
            Clusters clusters = this.domain.getClusters();
            if (this.node == null) {
                instance.setNode("localhost");
            }
            if (clusters != null && this.domain.getClusterNamed(instance.getName()) != null || this.domain.getConfigNamed(instance.getName()) != null) {
                throw new TransactionFailure(localStrings.getLocalString("cannotAddDuplicate", "There is an instance {0} already present.", new Object[]{instance.getName()}));
            }
            if (this.clusterName != null) {
                if (configRef != null) {
                    throw new TransactionFailure(localStrings.getLocalString("Server.cannotSpecifyBothConfigAndCluster", "A configuration name and cluster name cannot both be specified."));
                }
                boolean clusterExists = false;
                if (clusters != null) {
                    for (Cluster cluster : clusters.getCluster()) {
                        if (cluster == null || !this.clusterName.equals(cluster.getName())) continue;
                        ourCluster = cluster;
                        String configName = cluster.getConfigRef();
                        instance.setConfigRef(configName);
                        clusterExists = true;
                        ourConfig = this.domain.getConfigNamed(configName);
                        break;
                    }
                }
                if (!clusterExists) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchCluster", "Cluster {0} does not exist.", new Object[]{this.clusterName}));
                }
                Cluster cluster = this.domain.getClusterNamed(this.clusterName);
                String instanceName = instance.getName();
                try {
                    configConfigDir = new File(this.env.getConfigDirPath(), cluster.getConfigRef());
                    new File(configConfigDir, "docroot").mkdirs();
                    new File(configConfigDir, "lib/ext").mkdirs();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (cluster != null && tx != null) {
                    Cluster c = (Cluster)tx.enroll((ConfigBeanProxy)cluster);
                    ServerRef newServerRef = (ServerRef)c.createChild(ServerRef.class);
                    newServerRef.setRef(instanceName);
                    c.getServerRef().add(newServerRef);
                }
            }
            if (configRef != null) {
                Config specifiedConfig = this.domain.getConfigs().getConfigByName(configRef);
                if (specifiedConfig == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", new Object[]{configRef}));
                }
                ourConfig = specifiedConfig;
                try {
                    File configConfigDir2 = new File(this.env.getConfigDirPath(), specifiedConfig.getName());
                    new File(configConfigDir2, "docroot").mkdirs();
                    new File(configConfigDir2, "lib/ext").mkdirs();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (configRef == null && this.clusterName == null) {
                Config configCopy;
                Config defaultConfig = this.domain.getConfigs().getConfigByName("default-config");
                if (defaultConfig == null) {
                    String msg = localStrings.getLocalString(Server.class, "Cluster.noDefaultConfig", "Can''t find the default config (an element named \"default-config\") in domain.xml.  You may specify the name of an existing config element next time.");
                    logger.log(Level.SEVERE, msg);
                    throw new TransactionFailure(msg);
                }
                try {
                    configCopy = (Config)defaultConfig.deepCopy();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, localStrings.getLocalString(Server.class, "Cluster.error_while_copying", "Error while copying the default configuration {0}", new Object[]{e.toString(), e}));
                    throw new TransactionFailure(e.toString(), (Throwable)e);
                }
                ourConfig = configCopy;
                String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                try {
                    configConfigDir = new File(this.env.getConfigDirPath(), configName);
                    new File(configConfigDir, "docroot").mkdirs();
                    new File(configConfigDir, "lib/ext").mkdirs();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (tx != null) {
                    Configs configs = this.domain.getConfigs();
                    Configs writableConfigs = (Configs)tx.enroll((ConfigBeanProxy)configs);
                    Config writableConfigCopy = (Config)tx.enroll((ConfigBeanProxy)configCopy);
                    writableConfigCopy.setName(configName);
                    writableConfigs.getConfig().add(writableConfigCopy);
                }
            }
            for (Resource resource : this.domain.getResources().getResources()) {
                if (!resource.getObjectType().equals("system-all")) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)resource).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = (ResourceRef)instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all")) continue;
                ApplicationRef newAppRef = (ApplicationRef)instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
            PortManager pm = new PortManager(ourCluster, ourConfig, this.domain, instance);
            pm.process();
        }
    }

    public static class Duck {
        public static boolean isCluster(Server server) {
            return false;
        }

        public static boolean isServer(Server server) {
            return true;
        }

        public static boolean isInstance(Server server) {
            String name = server == null ? null : server.getName();
            return name != null && !name.equals("server");
        }

        public static boolean isDas(Server server) {
            String name = server == null ? null : server.getName();
            return "server".equals(name);
        }

        public static Cluster getCluster(Server server) {
            Dom serverDom = Dom.unwrap((ConfigBeanProxy)server);
            Clusters clusters = (Clusters)serverDom.getHabitat().getComponent(Clusters.class);
            if (clusters != null) {
                for (Cluster cluster : clusters.getCluster()) {
                    for (ServerRef serverRef : cluster.getServerRef()) {
                        if (!serverRef.getRef().equals(server.getName())) continue;
                        return cluster;
                    }
                }
            }
            return null;
        }

        public static String getReference(Server server) {
            return server.getConfigRef();
        }

        public static ApplicationRef getApplicationRef(Server server, String appName) {
            for (ApplicationRef appRef : server.getApplicationRef()) {
                if (!appRef.getRef().equals(appName)) continue;
                return appRef;
            }
            return null;
        }

        public static ResourceRef getResourceRef(Server server, String refName) {
            for (ResourceRef ref : server.getResourceRef()) {
                if (!ref.getRef().equals(refName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isResourceRefExists(Server server, String refName) {
            return Duck.getResourceRef(server, refName) != null;
        }

        public static void deleteResourceRef(Server server, String refName) throws TransactionFailure {
            final ResourceRef ref = Duck.getResourceRef(server, refName);
            if (ref != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                    public Object run(Server param) {
                        return param.getResourceRef().remove(ref);
                    }
                }, (ConfigBeanProxy)server);
            }
        }

        public static void createResourceRef(Server server, final String enabled, final String refName) throws TransactionFailure {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                public Object run(Server param) throws PropertyVetoException, TransactionFailure {
                    ResourceRef newResourceRef = (ResourceRef)param.createChild(ResourceRef.class);
                    newResourceRef.setEnabled(enabled);
                    newResourceRef.setRef(refName);
                    param.getResourceRef().add(newResourceRef);
                    return newResourceRef;
                }
            }, (ConfigBeanProxy)server);
        }
    }
}

