/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable")
@I18n(value="disable.command")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
public class DisableCommand
extends StateCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;

    public DisableCommand() {
        this.origin = OpsParams.Origin.unload;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        String appName = this.name();
        try {
            List matchedVersions = this.versioningService.getMatchedVersions(appName, this.target);
            if (matchedVersions == Collections.EMPTY_LIST) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            String enabledVersion = this.versioningService.getEnabledVersion(appName, this.target);
            if (!matchedVersions.contains(enabledVersion)) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            appName = enabledVersion;
        }
        catch (VersioningException e) {
            report.failure(logger, e.getMessage());
            return;
        }
        if (!this.deployment.isRegistered(appName)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{appName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ApplicationRef ref = this.domain.getApplicationRefInTarget(appName, this.target);
        if (ref == null) {
            report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{appName, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.domain.isCurrentInstanceMatchingTarget(this.target, this.server.getName())) {
            try {
                this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, false);
            }
            catch (TransactionFailure e) {
                logger.warning("failed to set enable attribute for " + this.name());
            }
            return;
        }
        ApplicationInfo appInfo = this.deployment.get(appName);
        try {
            UndeployCommandParameters commandParams = new UndeployCommandParameters();
            commandParams.origin = this.origin;
            commandParams.name = appName;
            ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(appInfo.getSource()).build();
            ApplicationName module = ConfigBeansUtilities.getModule((String)appName);
            Application application = null;
            if (module instanceof Application) {
                application = (Application)module;
            }
            if (application != null) {
                deploymentContext.getAppProps().putAll((Map<?, ?>)application.getDeployProperties());
                deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
            }
            appInfo.stop(deploymentContext, deploymentContext.getLogger());
            appInfo.unload(deploymentContext);
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                try {
                    this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, false);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to set enable attribute for " + this.name());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during disabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

