/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="postdeploy")
@Supplemental(value="deploy", ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class PostDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    @Inject
    private ClusterExecutor clusterExecutor;
    @Inject
    private Deployment deployment;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        DeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (params.target.equals("server")) {
            return;
        }
        try {
            ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap(dc);
            this.clusterExecutor.execute("_deploy", (AdminCommand)this, context, paramMap);
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
    }
}

