/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Cluster
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getConfigRef();

    @Param(name="config", optional=true)
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class, required=true)
    @NotNull
    public String getGmsEnabled();

    public void setGmsEnabled(String var1) throws PropertyVetoException;

    @Attribute
    @Min(value=2048L)
    @Max(value=32000L)
    @NotNull
    public String getGmsMulticastPort();

    @Param(name="multicastport", optional=true, alias="heartbeatport")
    public void setGmsMulticastPort(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getGmsMulticastAddress();

    @Param(name="multicastaddress", optional=true, alias="heartbeataddress")
    public void setGmsMulticastAddress(String var1) throws PropertyVetoException;

    @Attribute
    public String getGmsBindInterfaceAddress();

    public void setGmsBindInterfaceAddress(String var1) throws PropertyVetoException;

    @Deprecated
    @Attribute
    public String getHeartbeatEnabled();

    @Deprecated
    public void setHeartbeatEnabled(String var1) throws PropertyVetoException;

    @Attribute
    @Min(value=2048L)
    @Max(value=49151L)
    @Deprecated
    public String getHeartbeatPort();

    @Deprecated
    public void setHeartbeatPort(String var1) throws PropertyVetoException;

    @Attribute
    @Deprecated
    public String getHeartbeatAddress();

    @Deprecated
    public void setHeartbeatAddress(String var1) throws PropertyVetoException;

    @Element
    public List<ServerRef> getServerRef();

    @Override
    @Element
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system props")
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Complete PropertyDesc for legal props")
    @PropertiesDesc(props={@PropertyDesc(name="GMS_LISTENER_PORT", defaultValue="9090", description="GMS listener port")})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @DuckTyped
    public String getReference();

    @DuckTyped
    public List<Server> getInstances();

    @DuckTyped
    public boolean isCluster();

    @DuckTyped
    public boolean isServer();

    @DuckTyped
    public boolean isDas();

    @DuckTyped
    public boolean isInstance();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<Clusters, Cluster> {
        @Inject
        private Domain domain;
        @Inject
        Configs configs;
        @Inject
        private ServerEnvironment env;

        @Override
        public void decorate(AdminCommandContext context, Clusters parent, Cluster child) throws PropertyVetoException, TransactionFailure {
            Logger logger = LogDomains.getLogger(Cluster.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            ActionReport report = context.getActionReport();
            String instanceConfig = child.getConfigRef();
            Config config = this.configs.getConfigByName(instanceConfig);
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)parent);
            List<ServerRef> serverRefs = child.getServerRef();
            StringBuffer namesOfServers = new StringBuffer();
            if (serverRefs.size() > 0) {
                for (ServerRef serverRef : serverRefs) {
                    namesOfServers.append(new StringBuffer(serverRef.getRef()).append(','));
                }
                String msg = localStrings.getLocalString("Cluster.hasInstances", "Cluster {0} contains server instances {1} and must not contain any instances", new Object[]{child.getName(), namesOfServers.toString()});
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            if (config == null || this.domain.getReferenceContainersOf(config).size() > 1) {
                return;
            }
            try {
                File configConfigDir = new File(this.env.getConfigDirPath(), config.getName());
                FileUtils.whack((File)configConfigDir);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (t != null) {
                    Configs c = (Configs)t.enroll((ConfigBeanProxy)this.configs);
                    List<Config> configList = c.getConfig();
                    configList.remove(config);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", new Object[]{instanceConfig}), ex);
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", new Object[]{instanceConfig});
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                throw ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Cluster> {
        @Param(name="config", optional=true)
        String configRef = null;
        @Param(optional=true, obsolete=true)
        String hosts = null;
        @Param(optional=true, obsolete=true)
        String haagentport;
        @Param(optional=true, obsolete=true)
        String haadminpassword = null;
        @Param(optional=true, obsolete=true)
        String haadminpasswordfile = null;
        @Param(optional=true, obsolete=true)
        String devicesize = null;
        @Param(optional=true, obsolete=true)
        String haproperty = null;
        @Param(optional=true, obsolete=true)
        String autohadb = null;
        @Param(optional=true, obsolete=true)
        String portbase = null;
        @Inject
        Habitat habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;

        @Override
        public void decorate(AdminCommandContext context, Cluster instance) throws TransactionFailure, PropertyVetoException {
            Logger logger = LogDomains.getLogger(Cluster.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)instance);
            if (this.domain.getServerNamed(instance.getName()) != null || this.domain.getConfigNamed(instance.getName()) != null) {
                throw new TransactionFailure(localStrings.getLocalString("cannotAddDuplicate", "There is an instance {0} already present.", new Object[]{instance.getName()}));
            }
            String instanceName = instance.getName();
            instance.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", instanceName));
            if (instance.getGmsMulticastAddress() == null) {
                instance.setGmsMulticastAddress(this.generateHeartbeatAddress());
            }
            if (instance.getGmsMulticastPort() == null) {
                instance.setGmsMulticastPort(Integer.toString(this.generateHeartbeatPort()));
            }
            Property gmsListenerPort = (Property)instance.createChild(Property.class);
            gmsListenerPort.setName("GMS_LISTENER_PORT");
            gmsListenerPort.setValue(String.format("${GMS_LISTENER_PORT-%s}", instanceName));
            instance.getProperty().add(gmsListenerPort);
            if (this.configRef == null) {
                Config configCopy;
                Config config = (Config)this.habitat.getComponent(Config.class, "default-config");
                if (config == null) {
                    config = (Config)this.habitat.getAllByContract(Config.class).iterator().next();
                    logger.warning(localStrings.getLocalString(Cluster.class, "Cluster.no_default_config_found", "No default config found, using config {0} as the default config for the cluster {1}", new Object[]{config.getName(), instance.getName()}));
                }
                try {
                    configCopy = (Config)config.deepCopy();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, localStrings.getLocalString(Cluster.class, "Cluster.error_while_copying", "Error while copying the default configuration {0)", new Object[]{e.toString(), e}));
                    throw new TransactionFailure(e.toString(), (Throwable)e);
                }
                String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                try {
                    File configConfigDir = new File(this.env.getConfigDirPath(), configName);
                    new File(configConfigDir, "docroot").mkdirs();
                    new File(configConfigDir, "lib/ext").mkdirs();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (t != null) {
                    Configs configs = this.domain.getConfigs();
                    Configs writableConfigs = (Configs)t.enroll((ConfigBeanProxy)configs);
                    Config writableConfigCopy = (Config)t.enroll((ConfigBeanProxy)configCopy);
                    writableConfigCopy.setName(configName);
                    writableConfigs.getConfig().add(writableConfigCopy);
                }
            } else {
                Config specifiedConfig = this.domain.getConfigs().getConfigByName(this.configRef);
                if (specifiedConfig == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", new Object[]{this.configRef}));
                }
            }
            for (Resource resource : this.domain.getResources().getResources()) {
                if (!resource.getObjectType().equals("system-all")) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)resource).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = (ResourceRef)instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all")) continue;
                ApplicationRef newAppRef = (ApplicationRef)instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
            if (this.hosts != null || this.haagentport != null || this.haadminpassword != null || this.haadminpasswordfile != null || this.devicesize != null || this.haproperty != null || this.autohadb != null || this.portbase != null) {
                String msg = localStrings.getLocalString("Cluster.obsoleteOptions", "Obsolete options used");
                throw new TransactionFailure(msg);
            }
        }

        private int generateHeartbeatPort() {
            long MIN_GMS_MULTICAST_PORT = 2048L;
            long MAX_GMS_MULTICAST_PORT = 32000L;
            long portInterval = 29952L;
            return new Long(Math.round(Math.random() * (double)portInterval) + 2048L).intValue();
        }

        private String generateHeartbeatAddress() {
            int MAX_GMS_MULTICAST_ADDRESS_SUBRANGE = 255;
            StringBuffer heartbeatAddressBfr = new StringBuffer("228.9.");
            heartbeatAddressBfr.append(Math.round(Math.random() * 255.0)).append('.').append(Math.round(Math.random() * 255.0));
            return heartbeatAddressBfr.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static boolean isCluster(Cluster me) {
            return true;
        }

        public static boolean isServer(Cluster me) {
            return false;
        }

        public static boolean isInstance(Cluster me) {
            return false;
        }

        public static boolean isDas(Cluster me) {
            return false;
        }

        public static String getReference(Cluster cluster) {
            return cluster.getConfigRef();
        }

        public static List<Server> getInstances(Cluster cluster) {
            Dom clusterDom = Dom.unwrap((ConfigBeanProxy)cluster);
            Domain domain = (Domain)clusterDom.getHabitat().getComponent(Domain.class);
            ArrayList<Server> instances = new ArrayList<Server>();
            for (ServerRef sRef : cluster.getServerRef()) {
                Server svr = domain.getServerNamed(sRef.getRef());
                if (svr == null) continue;
                instances.add(domain.getServerNamed(sRef.getRef()));
            }
            return instances;
        }
    }
}

