/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.InvalidSecurityKeyException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class SecKey {
    private static final Random random;
    private static final char[] CHARS;
    private static final long MAX_SEC_KEY_VALUE = 0xFFFFFFFFL;
    private final String secKey;
    private final long secKeyValue;

    private SecKey(String secKey, long secKeyValue) {
        this.secKey = secKey;
        this.secKeyValue = secKeyValue;
    }

    public static SecKey create(String secKey) {
        return SecKey.validateSecKey(secKey);
    }

    public String getSecKey() {
        return this.secKey;
    }

    public long getSecKeyValue() {
        return this.secKeyValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.secKey.length() + 16);
        sb.append(this.secKey).append('(').append(this.secKeyValue).append(')');
        return sb.toString();
    }

    public static SecKey generateSecKey() {
        int position;
        int i;
        int spacesNum = random.nextInt(12) + 1;
        long number = Math.abs(random.nextLong()) % (0xFFFFFFFFL / (long)spacesNum);
        long product = number * (long)spacesNum;
        StringBuilder key = new StringBuilder();
        key.append(product);
        int charsNum = random.nextInt(12) + 1;
        for (i = 0; i < charsNum; ++i) {
            position = random.nextInt(key.length());
            char c = CHARS[random.nextInt(CHARS.length)];
            key.insert(position, c);
        }
        for (i = 0; i < spacesNum; ++i) {
            position = random.nextInt(key.length() - 1) + 1;
            key.insert(position, ' ');
        }
        return new SecKey(key.toString(), number);
    }

    public static byte[] generateServerKey(SecKey clientKey1, SecKey clientKey2, byte[] clientKey3) {
        MessageDigest md;
        ByteBuffer b = ByteBuffer.allocate(8);
        b.putInt((int)clientKey1.getSecKeyValue());
        b.putInt((int)clientKey2.getSecKeyValue());
        b.flip();
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        md.update(b);
        byte[] serverKey = md.digest(clientKey3);
        md.reset();
        assert (serverKey.length == 16);
        return serverKey;
    }

    public static SecKey validateSecKey(String key) {
        if (key.length() > 256) {
            throw new InvalidSecurityKeyException("Key too long");
        }
        int charsNum = 0;
        int spacesNum = 0;
        long productValue = 0L;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= '0' && c <= '9') {
                if ((productValue = productValue * 10L + (long)(c - 48)) <= 0xFFFFFFFFL) continue;
                throw new InvalidSecurityKeyException("Key value too large: " + productValue);
            }
            if (c == ' ') {
                if (++spacesNum <= 12) continue;
                continue;
            }
            if (c >= '!' && c <= '/' || c >= ':' && c <= '~') {
                if (++charsNum <= 12) continue;
                continue;
            }
            throw new InvalidSecurityKeyException("unexpected character: '" + c + "'");
        }
        if (spacesNum < 1) {
            throw new InvalidSecurityKeyException("number of spaces should be more than 1");
        }
        if (charsNum < 1) {
            throw new InvalidSecurityKeyException("number of chars should be more than 1");
        }
        if (productValue % (long)spacesNum != 0L) {
            throw new InvalidSecurityKeyException("remainder is not 0");
        }
        return new SecKey(key, productValue / (long)spacesNum);
    }

    static {
        int i;
        random = new Random();
        CHARS = new char[84];
        int idx = 0;
        for (i = 33; i <= 47; ++i) {
            SecKey.CHARS[idx++] = (char)i;
        }
        for (i = 58; i <= 126; ++i) {
            SecKey.CHARS[idx++] = (char)i;
        }
    }
}

