/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.enterprise.util.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.ServerReaderFilter;
import org.jvnet.hk2.component.Habitat;

class InstanceReaderFilter
extends ServerReaderFilter {
    private boolean parsedClusters;
    private boolean parsedServers;
    private boolean parsedServer;
    private boolean parsedConfigs;
    private final String instanceName;
    private String serverConfigName;
    private String clusterConfigName;
    private String clusterName;
    private XMLStreamReader reparseReader;
    private static final LocalStringsImpl strings = new LocalStringsImpl(InstanceReaderFilter.class);
    private static final String SERVERS = "servers";
    private static final String SERVER = "server";
    private static final String CLUSTERS = "clusters";
    private static final String CLUSTER = "cluster";
    private static final String REF = "ref";
    private static final String SERVER_REF = "server-ref";
    private static final String CONFIG = "config";
    private static final String CONFIGS = "configs";
    private static final String CONFIG_REF = "config-ref";
    private static final String NAME = "name";

    InstanceReaderFilter(String theServerName, Habitat theHabitat, URL theDomainXml, XMLInputFactory theXif) throws XMLStreamException {
        super(theHabitat, theDomainXml, theXif);
        this.instanceName = theServerName;
    }

    final boolean filterOut() throws XMLStreamException {
        try {
            XMLStreamReader reader = this.getParent();
            String elementName = reader.getLocalName();
            if (!StringUtils.ok((String)elementName)) {
                return true;
            }
            this.checkIfReparseRequired(elementName);
            if (elementName.equals(SERVER)) {
                return this.handleServer(reader);
            }
            if (elementName.equals(CONFIG)) {
                return this.handleConfig(reader);
            }
            return false;
        }
        catch (XMLStreamException xe) {
            throw xe;
        }
        catch (Exception e) {
            throw new XMLStreamException(strings.get("InstanceReaderFilter.UnknownException", new Object[]{e.toString()}), e);
        }
    }

    final String configWasFound() {
        if (this.serverConfigName != null) {
            return null;
        }
        return strings.get("InstanceReaderFilter.CantFindConfig", new Object[]{this.instanceName});
    }

    private void checkIfReparseRequired(String elementName) throws XMLStreamException {
        if (elementName.equals(CLUSTERS)) {
            this.parsedClusters = true;
            return;
        }
        if (elementName.equals(SERVERS)) {
            this.parsedServers = true;
            return;
        }
        if (elementName.equals(CONFIGS)) {
            this.parsedConfigs = true;
            if (!this.parsedClusters || !this.parsedServers) {
                this.reparseBegin();
            }
        }
    }

    private void reparseBegin() throws XMLStreamException {
        EarlyLogger.add((Level)Level.WARNING, (String)strings.get("InstanceReaderFilter.ReparseNeeded"));
        InputStream stream2 = null;
        this.reparseReader = null;
        try {
            stream2 = this.domainXml.openStream();
            this.reparseReader = this.xif.createXMLStreamReader(this.domainXml.toExternalForm(), stream2);
            while (this.reparseReader.hasNext()) {
                if (this.parsedServers && this.parsedClusters) {
                    break;
                }
                if (this.reparseReader.next() != 1) continue;
                this.reparse();
            }
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLStreamException("Failed to parse " + this.domainXml, e);
        }
        finally {
            try {
                this.reparseReader.close();
                stream2.close();
                this.reparseReader = null;
            }
            catch (Exception e) {}
        }
    }

    private void reparse() throws XMLStreamException {
        String name = this.reparseReader.getLocalName();
        if (!StringUtils.ok((String)name)) {
            return;
        }
        if (!this.parsedServers && name.equals(SERVERS)) {
            this.parsedServers = true;
            this.handleServers();
        }
        if (!this.parsedClusters && name.equals(CLUSTERS)) {
            this.parsedClusters = true;
            this.handleClusters();
        }
    }

    private boolean handleServer(XMLStreamReader r) {
        if (this.parsedServer) {
            return true;
        }
        String name = r.getAttributeValue(null, NAME);
        if (!this.instanceName.equals(name)) {
            return true;
        }
        this.parsedServer = true;
        this.serverConfigName = r.getAttributeValue(null, CONFIG_REF);
        if (this.clusterConfigName != null && this.clusterName != null) {
            return true;
        }
        Collection clusters = this.habitat.getAllByType(Cluster.class);
        for (Cluster cluster : clusters) {
            List<ServerRef> refs = cluster.getServerRef();
            for (ServerRef ref : refs) {
                if (!this.instanceName.equals(ref.getRef())) continue;
                this.clusterName = cluster.getName();
                this.clusterConfigName = cluster.getConfigRef();
                return false;
            }
        }
        return false;
    }

    private boolean handleConfig(XMLStreamReader reader) {
        String name = reader.getAttributeValue(null, NAME);
        if (!StringUtils.ok((String)name)) {
            return true;
        }
        if (!StringUtils.ok((String)this.serverConfigName)) {
            return true;
        }
        return !name.equals(this.serverConfigName) && !name.equals(this.clusterConfigName);
    }

    private void handleClusters() throws XMLStreamException {
        String cname = null;
        String ccfgname = null;
        try {
            while (true) {
                this.skipToStartButNotPast(CLUSTER, CLUSTERS);
                cname = this.reparseReader.getAttributeValue(null, NAME);
                ccfgname = this.reparseReader.getAttributeValue(null, CONFIG_REF);
                this.handleCluster();
            }
        }
        catch (GoodException ge) {
            this.clusterConfigName = ccfgname;
            this.clusterName = cname;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void handleServers() throws XMLStreamException {
        try {
            while (!this.parsedServer) {
                this.skipToStartButNotPast(SERVER, SERVERS);
                this.handleServer(this.reparseReader);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void handleCluster() throws GoodException, XMLStreamException {
        try {
            String ref;
            do {
                this.skipToStartButNotPast(SERVER_REF, CLUSTER);
            } while (!this.instanceName.equals(ref = this.reparseReader.getAttributeValue(null, REF)));
            throw new GoodException();
        }
        catch (GoodException ge) {
            throw ge;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void skipToStartButNotPast(String startName, String stopName) throws XMLStreamException, NotFoundException {
        while (this.reparseReader.hasNext()) {
            this.reparseReader.next();
            if (this.reparseReader.isStartElement() && startName.equals(this.reparseReader.getLocalName())) {
                return;
            }
            if (!this.reparseReader.isEndElement() || !stopName.equals(this.reparseReader.getLocalName())) continue;
            throw new NotFoundException();
        }
        throw new NotFoundException();
    }

    private static class NotFoundException
    extends Exception {
        private NotFoundException() {
        }
    }

    private static class GoodException
    extends Exception {
        private GoodException() {
        }
    }
}

