/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.InstanceCommandExecutor;
import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.config.support.CommandTarget;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterOperationUtil {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(ClusterOperationUtil.class);

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters, Habitat habitat) {
        ActionReport.ExitCode returnValue;
        block12: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            InstanceState instanceState = (InstanceState)habitat.getComponent(InstanceState.class);
            try {
                List<InstanceCommandExecutor> execList = ClusterOperationUtil.getInstanceCommandList(commandName, instancesForReplication, context.getLogger());
                for (InstanceCommandExecutor rac : execList) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    parameters.set((Object)"target", (Object)rac.getServer().getName());
                    try {
                        rac.executeCommand(parameters);
                        aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        if (StringUtils.ok(rac.getCommandOutput())) {
                            aReport.setMessage(rac.getServer().getName() + " : " + rac.getCommandOutput());
                            continue;
                        }
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandSuccessful", "Command {0} executed successfully on server instance {1}", commandName, rac.getServer().getName()));
                    }
                    catch (CommandException cmdEx) {
                        ActionReport.ExitCode finalResult;
                        if (cmdEx.getCause() instanceof ConnectException) {
                            finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)offlinePolicy, (ActionReport.ExitCode)ActionReport.ExitCode.WARNING);
                            if (!finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.warnoffline", "WARNING : Instance {0} seems to be offline; Command was not replicated to that instance", rac.getServer().getName()));
                            }
                        } else {
                            finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                            if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command {0} failed on server instance {1} : {2}", commandName, rac.getServer().getName(), cmdEx.getMessage()));
                            } else {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandWarning", "WARNING : Command {0} did not complete successfully on server instance {1} : {2}", commandName, rac.getServer().getName(), cmdEx.getMessage()));
                            }
                        }
                        aReport.setActionExitCode(finalResult);
                        if (returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            returnValue = finalResult;
                        }
                        instanceState.setState(rac.getServer().getName(), InstanceState.StateType.RESTART_REQUIRED);
                    }
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                ActionReport.ExitCode finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                aReport.setActionExitCode(finalResult);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication : {0}", ex.getMessage()));
                context.getLogger().severe("Error during command replication; Reason : " + ex.getLocalizedMessage());
                if (!returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) break block12;
                returnValue = finalResult;
            }
        }
        return returnValue;
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, Collection<String> targetNames, AdminCommandContext context, ParameterMap parameters, Habitat habitat) {
        ArrayList<Server> serversForReplication = new ArrayList<Server>();
        Target targetService = (Target)habitat.getComponent(Target.class);
        for (String t : targetNames) {
            if (CommandTarget.DAS.isValid(habitat, t) || CommandTarget.DOMAIN.isValid(habitat, t)) continue;
            serversForReplication.addAll(targetService.getInstances(t));
        }
        return ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, serversForReplication, context, parameters, habitat);
    }

    private static List<InstanceCommandExecutor> getInstanceCommandList(String commandName, List<Server> servers, Logger logger) throws CommandException {
        ArrayList<InstanceCommandExecutor> list = new ArrayList<InstanceCommandExecutor>();
        for (Server svr : servers) {
            String host = svr.getNodeAgentRef();
            int port = 4848;
            List sprops = svr.getSystemProperty();
            for (SystemProperty p : sprops) {
                if (!"ASADMIN_LISTENER_PORT".equals(p.getName())) continue;
                port = Integer.parseInt(p.getValue());
                break;
            }
            list.add(new InstanceCommandExecutor(commandName, svr, host, port, logger));
        }
        return list;
    }
}

